/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBigArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class LongBigArrayBlock
extends AbstractArrayBlock
implements LongBlock {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final LongBigArrayVector vector;

    public LongBigArrayBlock(LongArray values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        this(new LongBigArrayVector(values, firstValueIndexes == null ? positionCount : firstValueIndexes[positionCount], blockFactory), positionCount, firstValueIndexes, nulls, mvOrdering);
    }

    private LongBigArrayBlock(LongBigArrayVector vector, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering);
        this.vector = vector;
        assert (firstValueIndexes != null ? firstValueIndexes[this.getPositionCount()] == vector.getPositionCount() : vector.getPositionCount() == this.getPositionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LongBigArrayBlock readArrayBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        AbstractArrayBlock.SubFields sub = new AbstractArrayBlock.SubFields(blockFactory, (StreamInput)in);
        LongBigArrayVector vector = null;
        boolean success = false;
        try {
            vector = LongBigArrayVector.readArrayVector(sub.vectorPositions(), (StreamInput)in, blockFactory);
            LongBigArrayBlock block = new LongBigArrayBlock(vector, sub.positionCount, sub.firstValueIndexes, sub.nullsMask, sub.mvOrdering);
            blockFactory.adjustBreaker(block.ramBytesUsed() - vector.ramBytesUsed() - sub.bytesReserved);
            success = true;
            LongBigArrayBlock longBigArrayBlock = block;
            return longBigArrayBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)vector);
                blockFactory.adjustBreaker(-sub.bytesReserved);
            }
        }
    }

    void writeArrayBlock(StreamOutput out) throws IOException {
        this.writeSubFields(out);
        this.vector.writeArrayVector(this.vector.getPositionCount(), out);
    }

    @Override
    public LongVector asVector() {
        return null;
    }

    @Override
    public long getLong(int valueIndex) {
        return this.vector.getLong(valueIndex);
    }

    @Override
    public LongBlock filter(int ... positions) {
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendLong(this.getLong(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendLong(this.getLong(first + c));
                }
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.mvOrdering(this.mvOrdering()).build();
            return longBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public LongBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        if (this.nullsMask == null) {
            this.vector.incRef();
            return this.vector.asBlock();
        }
        int expandedPositionCount = this.vector.getPositionCount();
        long bitSetRamUsedEstimate = Math.max((long)this.nullsMask.size(), BlockRamUsageEstimator.sizeOfBitSet(expandedPositionCount));
        this.blockFactory().adjustBreaker(bitSetRamUsedEstimate);
        LongBigArrayBlock expanded = new LongBigArrayBlock(this.vector, expandedPositionCount, null, this.shiftNullsToExpandedPositions(), Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        this.blockFactory().adjustBreaker(expanded.ramBytesUsedOnlyBlock() - bitSetRamUsedEstimate);
        this.vector.incRef();
        return expanded;
    }

    private long ramBytesUsedOnlyBlock() {
        return 0L + BlockRamUsageEstimator.sizeOf(this.firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(this.nullsMask);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedOnlyBlock() + RamUsageEstimator.sizeOf((Accountable)this.vector);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongBlock) {
            LongBlock that = (LongBlock)obj;
            return LongBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", ramBytesUsed=" + this.vector.ramBytesUsed() + "]";
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsedOnlyBlock());
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

