/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DocBlock;

public enum ElementType {
    BOOLEAN(BlockFactory::newBooleanBlockBuilder),
    INT(BlockFactory::newIntBlockBuilder),
    LONG(BlockFactory::newLongBlockBuilder),
    DOUBLE(BlockFactory::newDoubleBlockBuilder),
    NULL((blockFactory, estimatedSize) -> new ConstantNullBlock.Builder(blockFactory)),
    BYTES_REF(BlockFactory::newBytesRefBlockBuilder),
    DOC(DocBlock::newBlockBuilder),
    UNKNOWN((blockFactory, estimatedSize) -> {
        throw new UnsupportedOperationException("can't build null blocks");
    });

    private final BuilderSupplier builder;

    private ElementType(BuilderSupplier builder) {
        this.builder = builder;
    }

    public Block.Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return this.builder.newBlockBuilder(blockFactory, estimatedSize);
    }

    public static ElementType fromJava(Class<?> type) {
        ElementType elementType;
        if (type == Integer.class) {
            elementType = INT;
        } else if (type == Long.class) {
            elementType = LONG;
        } else if (type == Double.class) {
            elementType = DOUBLE;
        } else if (type == String.class || type == BytesRef.class) {
            elementType = BYTES_REF;
        } else if (type == Boolean.class) {
            elementType = BOOLEAN;
        } else if (type == null || type == Void.class) {
            elementType = NULL;
        } else {
            throw new IllegalArgumentException("Unrecognized class type " + type);
        }
        return elementType;
    }

    private static interface BuilderSupplier {
        public Block.Builder newBlockBuilder(BlockFactory var1, int var2);
    }
}

