/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BytesRefArrayVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class BytesRefArrayBlock
extends AbstractArrayBlock
implements BytesRefBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefArrayBlock.class);
    private final BytesRefArrayVector vector;

    BytesRefArrayBlock(BytesRefArray values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        this(new BytesRefArrayVector(values, firstValueIndexes == null ? positionCount : firstValueIndexes[positionCount], blockFactory), positionCount, firstValueIndexes, nulls, mvOrdering);
    }

    private BytesRefArrayBlock(BytesRefArrayVector vector, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering);
        this.vector = vector;
        assert (firstValueIndexes != null ? firstValueIndexes[this.getPositionCount()] == vector.getPositionCount() : vector.getPositionCount() == this.getPositionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BytesRefArrayBlock readArrayBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        AbstractArrayBlock.SubFields sub = new AbstractArrayBlock.SubFields(blockFactory, (StreamInput)in);
        BytesRefArrayVector vector = null;
        boolean success = false;
        try {
            vector = BytesRefArrayVector.readArrayVector(sub.vectorPositions(), (StreamInput)in, blockFactory);
            BytesRefArrayBlock block = new BytesRefArrayBlock(vector, sub.positionCount, sub.firstValueIndexes, sub.nullsMask, sub.mvOrdering);
            blockFactory.adjustBreaker(block.ramBytesUsed() - vector.ramBytesUsed() - sub.bytesReserved);
            success = true;
            BytesRefArrayBlock bytesRefArrayBlock = block;
            return bytesRefArrayBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)vector);
                blockFactory.adjustBreaker(-sub.bytesReserved);
            }
        }
    }

    void writeArrayBlock(StreamOutput out) throws IOException {
        this.writeSubFields(out);
        this.vector.writeArrayVector(this.vector.getPositionCount(), out);
    }

    @Override
    public BytesRefVector asVector() {
        return null;
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        return this.vector.getBytesRef(valueIndex, dest);
    }

    @Override
    public BytesRefBlock filter(int ... positions) {
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock.Builder builder = this.blockFactory().newBytesRefBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendBytesRef(this.getBytesRef(this.getFirstValueIndex(pos), scratch));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendBytesRef(this.getBytesRef(first + c, scratch));
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.mvOrdering(this.mvOrdering()).build();
            return bytesRefBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public BytesRefBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        if (this.nullsMask == null) {
            this.vector.incRef();
            return this.vector.asBlock();
        }
        int expandedPositionCount = this.vector.getPositionCount();
        long bitSetRamUsedEstimate = Math.max((long)this.nullsMask.size(), BlockRamUsageEstimator.sizeOfBitSet(expandedPositionCount));
        this.blockFactory().adjustBreaker(bitSetRamUsedEstimate);
        BytesRefArrayBlock expanded = new BytesRefArrayBlock(this.vector, expandedPositionCount, null, this.shiftNullsToExpandedPositions(), Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        this.blockFactory().adjustBreaker(expanded.ramBytesUsedOnlyBlock() - bitSetRamUsedEstimate);
        this.vector.incRef();
        return expanded;
    }

    private long ramBytesUsedOnlyBlock() {
        return BASE_RAM_BYTES_USED + BlockRamUsageEstimator.sizeOf(this.firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(this.nullsMask);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedOnlyBlock() + this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefBlock) {
            BytesRefBlock that = (BytesRefBlock)obj;
            return BytesRefBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", vector=" + this.vector + "]";
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsedOnlyBlock());
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

