/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanBigArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BooleanVector
extends Vector {
    public boolean getBoolean(int var1);

    @Override
    public BooleanBlock asBlock();

    @Override
    public BooleanVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BooleanVector vector1, BooleanVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getBoolean(pos) == vector2.getBoolean(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(BooleanVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + Boolean.hashCode(vector.getBoolean(pos));
        }
        return result;
    }

    public static BooleanVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> BooleanVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantBooleanVector(in.readBoolean(), positions);
            case 2 -> BooleanArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> BooleanBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        BooleanVector booleanVector;
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeBoolean(this.getBoolean(0));
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_ARRAY_VECTOR) && (booleanVector = this) instanceof BooleanArrayVector) {
            BooleanArrayVector v = (BooleanArrayVector)booleanVector;
            out.writeByte((byte)2);
            v.writeArrayVector(positions, out);
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_BIG_VECTOR) && (booleanVector = this) instanceof BooleanBigArrayVector) {
            BooleanBigArrayVector v = (BooleanBigArrayVector)booleanVector;
            out.writeByte((byte)3);
            v.writeArrayVector(positions, out);
        } else {
            out.writeByte((byte)0);
            BooleanVector.writeValues(this, positions, out);
        }
    }

    private static BooleanVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newBooleanVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendBoolean(in.readBoolean());
            }
            BooleanVector booleanVector = builder.build();
            return booleanVector;
        }
    }

    private static void writeValues(BooleanVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeBoolean(v.getBoolean(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Builder {
        @Override
        public FixedBuilder appendBoolean(boolean var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendBoolean(boolean var1);

        @Override
        public BooleanVector build();
    }
}

