/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanArrayBlock;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanBlockBuilder;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBuilder;
import org.elasticsearch.compute.data.BooleanVectorFixedBuilder;
import org.elasticsearch.compute.data.BytesRefArrayBlock;
import org.elasticsearch.compute.data.BytesRefArrayVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefBlockBuilder;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBuilder;
import org.elasticsearch.compute.data.ConstantBooleanVector;
import org.elasticsearch.compute.data.ConstantBytesRefVector;
import org.elasticsearch.compute.data.ConstantDoubleVector;
import org.elasticsearch.compute.data.ConstantIntVector;
import org.elasticsearch.compute.data.ConstantLongVector;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DoubleArrayBlock;
import org.elasticsearch.compute.data.DoubleArrayVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleBlockBuilder;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.DoubleVectorBuilder;
import org.elasticsearch.compute.data.DoubleVectorFixedBuilder;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntBlockBuilder;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBuilder;
import org.elasticsearch.compute.data.IntVectorFixedBuilder;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.compute.data.LongArrayBlock;
import org.elasticsearch.compute.data.LongArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongBlockBuilder;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.LongVectorBuilder;
import org.elasticsearch.compute.data.LongVectorFixedBuilder;

public class BlockFactory {
    public static final String LOCAL_BREAKER_OVER_RESERVED_SIZE_SETTING = "esql.block_factory.local_breaker.over_reserved";
    public static final ByteSizeValue LOCAL_BREAKER_OVER_RESERVED_DEFAULT_SIZE = ByteSizeValue.ofKb((long)4L);
    public static final String LOCAL_BREAKER_OVER_RESERVED_MAX_SIZE_SETTING = "esql.block_factory.local_breaker.max_over_reserved";
    public static final ByteSizeValue LOCAL_BREAKER_OVER_RESERVED_DEFAULT_MAX_SIZE = ByteSizeValue.ofKb((long)16L);
    public static final String MAX_BLOCK_PRIMITIVE_ARRAY_SIZE_SETTING = "esql.block_factory.max_block_primitive_array_size";
    public static final ByteSizeValue DEFAULT_MAX_BLOCK_PRIMITIVE_ARRAY_SIZE = ByteSizeValue.ofKb((long)512L);
    private final CircuitBreaker breaker;
    private final BigArrays bigArrays;
    private final long maxPrimitiveArrayBytes;
    private final BlockFactory parent;

    public BlockFactory(CircuitBreaker breaker, BigArrays bigArrays) {
        this(breaker, bigArrays, DEFAULT_MAX_BLOCK_PRIMITIVE_ARRAY_SIZE);
    }

    public BlockFactory(CircuitBreaker breaker, BigArrays bigArrays, ByteSizeValue maxPrimitiveArraySize) {
        this(breaker, bigArrays, maxPrimitiveArraySize, null);
    }

    protected BlockFactory(CircuitBreaker breaker, BigArrays bigArrays, ByteSizeValue maxPrimitiveArraySize, BlockFactory parent) {
        assert (!(breaker instanceof LocalCircuitBreaker) || parent != null && ((LocalCircuitBreaker)breaker).parentBreaker() == parent.breaker) : "use local breaker without parent block factory";
        this.breaker = breaker;
        this.bigArrays = bigArrays;
        this.parent = parent;
        this.maxPrimitiveArrayBytes = maxPrimitiveArraySize.getBytes();
    }

    public static BlockFactory getInstance(CircuitBreaker breaker, BigArrays bigArrays) {
        return new BlockFactory(breaker, bigArrays, DEFAULT_MAX_BLOCK_PRIMITIVE_ARRAY_SIZE, null);
    }

    public CircuitBreaker breaker() {
        return this.breaker;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    protected BlockFactory parent() {
        return this.parent != null ? this.parent : this;
    }

    public BlockFactory newChildFactory(LocalCircuitBreaker childBreaker) {
        if (childBreaker.parentBreaker() != this.breaker) {
            throw new IllegalStateException("Different parent breaker");
        }
        return new BlockFactory(childBreaker, this.bigArrays, ByteSizeValue.ofBytes((long)this.maxPrimitiveArrayBytes), this);
    }

    void adjustBreaker(long delta) throws CircuitBreakingException {
        if (delta > 0L) {
            this.breaker.addEstimateBytesAndMaybeBreak(delta, "<esql_block_factory>");
        } else {
            this.breaker.addWithoutBreaking(delta);
        }
    }

    public long preAdjustBreakerForBoolean(int positionCount) {
        long bytes = (long)positionCount * 1L;
        this.adjustBreaker(bytes);
        return bytes;
    }

    public long preAdjustBreakerForInt(int positionCount) {
        long bytes = (long)positionCount * 4L;
        this.adjustBreaker(bytes);
        return bytes;
    }

    public long preAdjustBreakerForLong(int positionCount) {
        long bytes = (long)positionCount * 8L;
        this.adjustBreaker(bytes);
        return bytes;
    }

    public long preAdjustBreakerForDouble(int positionCount) {
        long bytes = (long)positionCount * 8L;
        this.adjustBreaker(bytes);
        return bytes;
    }

    public BooleanBlock.Builder newBooleanBlockBuilder(int estimatedSize) {
        return new BooleanBlockBuilder(estimatedSize, this);
    }

    public BooleanVector.FixedBuilder newBooleanVectorFixedBuilder(int size) {
        return new BooleanVectorFixedBuilder(size, this);
    }

    public final BooleanBlock newBooleanArrayBlock(boolean[] values, int pc, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        return this.newBooleanArrayBlock(values, pc, firstValueIndexes, nulls, mvOrdering, 0L);
    }

    public BooleanBlock newBooleanArrayBlock(boolean[] values, int pc, int[] fvi, BitSet nulls, Block.MvOrdering mvOrder, long preAdjustedBytes) {
        BooleanArrayBlock b = new BooleanArrayBlock(values, pc, fvi, nulls, mvOrder, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public BooleanVector.Builder newBooleanVectorBuilder(int estimatedSize) {
        return new BooleanVectorBuilder(estimatedSize, this);
    }

    public final BooleanVector newBooleanArrayVector(boolean[] values, int positionCount) {
        return this.newBooleanArrayVector(values, positionCount, 0L);
    }

    public BooleanVector newBooleanArrayVector(boolean[] values, int positionCount, long preAdjustedBytes) {
        BooleanArrayVector b = new BooleanArrayVector(values, positionCount, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public final BooleanBlock newConstantBooleanBlockWith(boolean value, int positions) {
        return this.newConstantBooleanBlockWith(value, positions, 0L);
    }

    public BooleanBlock newConstantBooleanBlockWith(boolean value, int positions, long preAdjustedBytes) {
        BooleanBlock b = new ConstantBooleanVector(value, positions, this).asBlock();
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public BooleanVector newConstantBooleanVector(boolean value, int positions) {
        this.adjustBreaker(ConstantBooleanVector.RAM_BYTES_USED);
        ConstantBooleanVector v = new ConstantBooleanVector(value, positions, this);
        assert (v.ramBytesUsed() == ConstantBooleanVector.RAM_BYTES_USED);
        return v;
    }

    public IntBlock.Builder newIntBlockBuilder(int estimatedSize) {
        return new IntBlockBuilder(estimatedSize, this);
    }

    public final IntBlock newIntArrayBlock(int[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        return this.newIntArrayBlock(values, positionCount, firstValueIndexes, nulls, mvOrdering, 0L);
    }

    public IntBlock newIntArrayBlock(int[] values, int pc, int[] fvi, BitSet nulls, Block.MvOrdering mvOrdering, long preAdjustedBytes) {
        IntArrayBlock b = new IntArrayBlock(values, pc, fvi, nulls, mvOrdering, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public IntVector.Builder newIntVectorBuilder(int estimatedSize) {
        return new IntVectorBuilder(estimatedSize, this);
    }

    public IntVector.FixedBuilder newIntVectorFixedBuilder(int size) {
        return new IntVectorFixedBuilder(size, this);
    }

    public final IntVector newIntArrayVector(int[] values, int positionCount) {
        return this.newIntArrayVector(values, positionCount, 0L);
    }

    public IntVector newIntArrayVector(int[] values, int positionCount, long preAdjustedBytes) {
        IntArrayVector b = new IntArrayVector(values, positionCount, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public final IntBlock newConstantIntBlockWith(int value, int positions) {
        return this.newConstantIntBlockWith(value, positions, 0L);
    }

    public IntBlock newConstantIntBlockWith(int value, int positions, long preAdjustedBytes) {
        IntBlock b = new ConstantIntVector(value, positions, this).asBlock();
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public IntVector newConstantIntVector(int value, int positions) {
        this.adjustBreaker(ConstantIntVector.RAM_BYTES_USED);
        ConstantIntVector v = new ConstantIntVector(value, positions, this);
        assert (v.ramBytesUsed() == ConstantIntVector.RAM_BYTES_USED);
        return v;
    }

    public LongBlock.Builder newLongBlockBuilder(int estimatedSize) {
        return new LongBlockBuilder(estimatedSize, this);
    }

    public final LongBlock newLongArrayBlock(long[] values, int pc, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        return this.newLongArrayBlock(values, pc, firstValueIndexes, nulls, mvOrdering, 0L);
    }

    public LongBlock newLongArrayBlock(long[] values, int pc, int[] fvi, BitSet nulls, Block.MvOrdering mvOrdering, long preAdjustedBytes) {
        LongArrayBlock b = new LongArrayBlock(values, pc, fvi, nulls, mvOrdering, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public LongVector.Builder newLongVectorBuilder(int estimatedSize) {
        return new LongVectorBuilder(estimatedSize, this);
    }

    public LongVector.FixedBuilder newLongVectorFixedBuilder(int size) {
        return new LongVectorFixedBuilder(size, this);
    }

    public final LongVector newLongArrayVector(long[] values, int positionCount) {
        return this.newLongArrayVector(values, positionCount, 0L);
    }

    public LongVector newLongArrayVector(long[] values, int positionCount, long preAdjustedBytes) {
        LongArrayVector b = new LongArrayVector(values, positionCount, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public final LongBlock newConstantLongBlockWith(long value, int positions) {
        return this.newConstantLongBlockWith(value, positions, 0L);
    }

    public LongBlock newConstantLongBlockWith(long value, int positions, long preAdjustedBytes) {
        LongBlock b = new ConstantLongVector(value, positions, this).asBlock();
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public LongVector newConstantLongVector(long value, int positions) {
        this.adjustBreaker(ConstantLongVector.RAM_BYTES_USED);
        ConstantLongVector v = new ConstantLongVector(value, positions, this);
        assert (v.ramBytesUsed() == ConstantLongVector.RAM_BYTES_USED);
        return v;
    }

    public DoubleBlock.Builder newDoubleBlockBuilder(int estimatedSize) {
        return new DoubleBlockBuilder(estimatedSize, this);
    }

    public final DoubleBlock newDoubleArrayBlock(double[] values, int pc, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        return this.newDoubleArrayBlock(values, pc, firstValueIndexes, nulls, mvOrdering, 0L);
    }

    public DoubleBlock newDoubleArrayBlock(double[] values, int pc, int[] fvi, BitSet nulls, Block.MvOrdering mvOrdering, long preAdjustedBytes) {
        DoubleArrayBlock b = new DoubleArrayBlock(values, pc, fvi, nulls, mvOrdering, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public DoubleVector.Builder newDoubleVectorBuilder(int estimatedSize) {
        return new DoubleVectorBuilder(estimatedSize, this);
    }

    public DoubleVector.FixedBuilder newDoubleVectorFixedBuilder(int size) {
        return new DoubleVectorFixedBuilder(size, this);
    }

    public final DoubleVector newDoubleArrayVector(double[] values, int positionCount) {
        return this.newDoubleArrayVector(values, positionCount, 0L);
    }

    public DoubleVector newDoubleArrayVector(double[] values, int positionCount, long preAdjustedBytes) {
        DoubleArrayVector b = new DoubleArrayVector(values, positionCount, this);
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public final DoubleBlock newConstantDoubleBlockWith(double value, int positions) {
        return this.newConstantDoubleBlockWith(value, positions, 0L);
    }

    public DoubleBlock newConstantDoubleBlockWith(double value, int positions, long preAdjustedBytes) {
        DoubleBlock b = new ConstantDoubleVector(value, positions, this).asBlock();
        this.adjustBreaker(b.ramBytesUsed() - preAdjustedBytes);
        return b;
    }

    public DoubleVector newConstantDoubleVector(double value, int positions) {
        this.adjustBreaker(ConstantDoubleVector.RAM_BYTES_USED);
        ConstantDoubleVector v = new ConstantDoubleVector(value, positions, this);
        assert (v.ramBytesUsed() == ConstantDoubleVector.RAM_BYTES_USED);
        return v;
    }

    public BytesRefBlock.Builder newBytesRefBlockBuilder(int estimatedSize) {
        return new BytesRefBlockBuilder(estimatedSize, this.bigArrays, this);
    }

    public BytesRefBlock newBytesRefArrayBlock(BytesRefArray values, int pc, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        BytesRefArrayBlock b = new BytesRefArrayBlock(values, pc, firstValueIndexes, nulls, mvOrdering, this);
        this.adjustBreaker(b.ramBytesUsed() - values.bigArraysRamBytesUsed());
        return b;
    }

    public BytesRefVector.Builder newBytesRefVectorBuilder(int estimatedSize) {
        return new BytesRefVectorBuilder(estimatedSize, this.bigArrays, this);
    }

    public BytesRefVector newBytesRefArrayVector(BytesRefArray values, int positionCount) {
        BytesRefArrayVector b = new BytesRefArrayVector(values, positionCount, this);
        this.adjustBreaker(b.ramBytesUsed() - values.bigArraysRamBytesUsed());
        return b;
    }

    public BytesRefBlock newConstantBytesRefBlockWith(BytesRef value, int positions) {
        BytesRefBlock b = new ConstantBytesRefVector(value, positions, this).asBlock();
        this.adjustBreaker(b.ramBytesUsed());
        return b;
    }

    public BytesRefVector newConstantBytesRefVector(BytesRef value, int positions) {
        long preadjusted = ConstantBytesRefVector.ramBytesUsed(value);
        this.adjustBreaker(preadjusted);
        ConstantBytesRefVector v = new ConstantBytesRefVector(value, positions, this);
        assert (v.ramBytesUsed() == preadjusted);
        return v;
    }

    public Block newConstantNullBlock(int positions) {
        ConstantNullBlock b = new ConstantNullBlock(positions, this);
        this.adjustBreaker(b.ramBytesUsed());
        return b;
    }

    public long maxPrimitiveArrayBytes() {
        return this.maxPrimitiveArrayBytes;
    }
}

