/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;

final class NullBlockHash
extends BlockHash {
    private final int channel;
    private boolean seenNull = false;

    NullBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        } else {
            throw new IllegalArgumentException("can't use NullBlockHash for non-null blocks");
        }
    }

    @Override
    public Block[] getKeys() {
        return new Block[]{this.blockFactory.newConstantNullBlock(this.seenNull ? 1 : 0)};
    }

    @Override
    public IntVector nonEmpty() {
        return this.blockFactory.newConstantIntVector(0, this.seenNull ? 1 : 0);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        BitArray seen = new BitArray(1L, bigArrays);
        if (this.seenNull) {
            seen.set(0L);
        }
        return seen;
    }

    public void close() {
    }

    public String toString() {
        return "NullBlockHash{channel=" + this.channel + ", seenNull=" + this.seenNull + "}";
    }
}

