/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.BitSet;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.MultivalueDedupe;
import org.elasticsearch.compute.operator.MultivalueDedupeLong;

final class LongBlockHash
extends BlockHash {
    private final int channel;
    private final LongHash longHash;
    private boolean seenNull;

    LongBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
        this.longHash = new LongHash(1L, blockFactory.bigArrays());
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        }
        LongBlock longBlock = (LongBlock)page.getBlock(this.channel);
        LongVector longVector = longBlock.asVector();
        if (longVector == null) {
            try (IntBlock groupIds = this.add(longBlock);){
                addInput.add(0, groupIds);
            }
        }
        try (IntVector groupIds = this.add(longVector);){
            addInput.add(0, groupIds);
        }
    }

    private IntVector add(LongVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(Math.toIntExact(LongBlockHash.hashOrdToGroupNullReserved(this.longHash.add(vector.getLong(i)))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock add(LongBlock block) {
        MultivalueDedupe.HashResult result = new MultivalueDedupeLong(block).hash(this.blockFactory, this.longHash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    public LongBlock[] getKeys() {
        if (this.seenNull) {
            int size = Math.toIntExact(this.longHash.size() + 1L);
            long[] keys = new long[size];
            for (int i = 1; i < size; ++i) {
                keys[i] = this.longHash.get((long)(i - 1));
            }
            BitSet nulls = new BitSet(1);
            nulls.set(0);
            return new LongBlock[]{this.blockFactory.newLongArrayBlock(keys, keys.length, null, nulls, Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING)};
        }
        int size = Math.toIntExact(this.longHash.size());
        long[] keys = new long[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.longHash.get((long)i);
        }
        return new LongBlock[]{this.blockFactory.newLongArrayVector(keys, keys.length).asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.longHash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.longHash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.longHash.close();
    }

    public String toString() {
        return "LongBlockHash{channel=" + this.channel + ", entries=" + this.longHash.size() + ", seenNull=" + this.seenNull + "}";
    }
}

