/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;

class ValuesLongAggregator {
    ValuesLongAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, long v) {
        state.values.add(v);
    }

    public static void combineIntermediate(SingleState state, LongBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesLongAggregator.combine(state, values.getLong(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, long v) {
        state.values.add((long)groupId, v);
    }

    public static void combineIntermediate(GroupingState state, int groupId, LongBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesLongAggregator.combine(state, groupId, values.getLong(i));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        int id = 0;
        while ((long)id < state.values.size()) {
            if (state.values.getKey1((long)id) == (long)statePosition) {
                long value = state.values.getKey2((long)id);
                ValuesLongAggregator.combine(current, currentGroupId, value);
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements Releasable {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantLongBlockWith(this.values.get(0L), 1);
            }
            try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendLong(this.values.get((long)id));
                    ++id;
                }
                builder.endPositionEntry();
                LongBlock longBlock = builder.build();
                return longBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements Releasable {
        private final LongLongHash values;

        private GroupingState(BigArrays bigArrays) {
            this.values = new LongLongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(selected.getPositionCount());){
                block13: for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int selectedGroup = selected.getInt(s);
                    int count = 0;
                    long first = 0L;
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        if (this.values.getKey1((long)id) == (long)selectedGroup) {
                            long value = this.values.getKey2((long)id);
                            switch (count) {
                                case 0: {
                                    first = value;
                                    break;
                                }
                                case 1: {
                                    builder.beginPositionEntry();
                                    builder.appendLong(first);
                                    builder.appendLong(value);
                                    break;
                                }
                                default: {
                                    builder.appendLong(value);
                                }
                            }
                            ++count;
                        }
                        ++id;
                    }
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            continue block13;
                        }
                        case 1: {
                            builder.appendLong(first);
                            continue block13;
                        }
                        default: {
                            builder.endPositionEntry();
                        }
                    }
                }
                LongBlock longBlock = builder.build();
                return longBlock;
            }
        }

        void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            this.values.close();
        }
    }
}

