/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.DoubleState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MinDoubleAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MinDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("min", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final DoubleState state;
    private final List<Integer> channels;

    public MinDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, DoubleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MinDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MinDoubleAggregatorFunction(driverContext, channels, new DoubleState(MinDoubleAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(DoubleVector vector) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            this.state.doubleValue(MinDoubleAggregator.combine(this.state.doubleValue(), vector.getDouble(i)));
        }
    }

    private void addRawBlock(DoubleBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                this.state.doubleValue(MinDoubleAggregator.combine(this.state.doubleValue(), block.getDouble(i)));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MinDoubleAggregatorFunction.intermediateStateDesc().size());
        Object minUncast = page.getBlock(this.channels.get(0));
        if (minUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector min = ((DoubleBlock)minUncast).asVector();
        assert (min.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        if (seen.getBoolean(0)) {
            this.state.doubleValue(MinDoubleAggregator.combine(this.state.doubleValue(), min.getDouble(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = driverContext.blockFactory().newConstantDoubleBlockWith(this.state.doubleValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

