/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.function.Function;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;

public class GroupingAggregator
implements Releasable {
    private final GroupingAggregatorFunction aggregatorFunction;
    private final AggregatorMode mode;

    public GroupingAggregator(GroupingAggregatorFunction aggregatorFunction, AggregatorMode mode) {
        this.aggregatorFunction = aggregatorFunction;
        this.mode = mode;
    }

    public int evaluateBlockCount() {
        return this.mode.isOutputPartial() ? this.aggregatorFunction.intermediateBlockCount() : 1;
    }

    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, final Page page) {
        if (this.mode.isInputPartial()) {
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    throw new IllegalStateException("Intermediate group id must not have nulls");
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    GroupingAggregator.this.aggregatorFunction.addIntermediateInput(positionOffset, groupIds, page);
                }
            };
        }
        return this.aggregatorFunction.prepareProcessPage(seenGroupIds, page);
    }

    public void addIntermediateRow(int groupId, GroupingAggregator input, int position) {
        this.aggregatorFunction.addIntermediateRowInput(groupId, input.aggregatorFunction, position);
    }

    public void evaluate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        if (this.mode.isOutputPartial()) {
            this.aggregatorFunction.evaluateIntermediate(blocks, offset, selected);
        } else {
            this.aggregatorFunction.evaluateFinal(blocks, offset, selected, driverContext);
        }
    }

    public void close() {
        this.aggregatorFunction.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("aggregatorFunction=").append(this.aggregatorFunction).append(", ");
        sb.append("mode=").append((Object)this.mode);
        sb.append("]");
        return sb.toString();
    }

    public static interface Factory
    extends Function<DriverContext, GroupingAggregator>,
    Describable {
    }
}

