/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;
import org.elasticsearch.xpack.rollup.RollupJobIdentifierUtils;
import org.elasticsearch.xpack.rollup.RollupRequestTranslator;
import org.elasticsearch.xpack.rollup.RollupResponseTranslator;
import org.elasticsearch.xpack.rollup.action.RollupIndexCaps;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;

public class TransportRollupSearchAction
extends TransportAction<SearchRequest, SearchResponse> {
    private final Client client;
    private final NamedWriteableRegistry registry;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private static final Logger logger = LogManager.getLogger(RollupSearchAction.class);

    @Inject
    public TransportRollupSearchAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedWriteableRegistry registry, BigArrays bigArrays, ScriptService scriptService, ClusterService clusterService, IndexNameExpressionResolver resolver) {
        super("indices:data/read/xpack/rollup/search", actionFilters, transportService.getTaskManager());
        this.client = client;
        this.registry = registry;
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.resolver = resolver;
        transportService.registerRequestHandler(this.actionName, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, false, true, SearchRequest::new, (TransportRequestHandler)new TransportHandler());
    }

    protected void doExecute(final Task task, final SearchRequest request, ActionListener<SearchResponse> listener) {
        String[] indices = this.resolver.concreteIndexNames(this.clusterService.state(), (IndicesRequest)request);
        RollupSearchContext rollupSearchContext = TransportRollupSearchAction.separateIndices(indices, this.clusterService.state().getMetadata().indices());
        MultiSearchRequest msearch = TransportRollupSearchAction.createMSearchRequest(request, this.registry, rollupSearchContext);
        this.client.multiSearch(msearch, ActionListener.wrap(msearchResponse -> {
            AggregationReduceContext.Builder reduceContextBuilder = new AggregationReduceContext.Builder(){

                public AggregationReduceContext forPartialReduction() {
                    return new AggregationReduceContext.ForPartial(TransportRollupSearchAction.this.bigArrays, TransportRollupSearchAction.this.scriptService, () -> ((CancellableTask)((CancellableTask)task)).isCancelled(), request.source().aggregations());
                }

                public AggregationReduceContext forFinalReduction() {
                    return new AggregationReduceContext.ForFinal(TransportRollupSearchAction.this.bigArrays, TransportRollupSearchAction.this.scriptService, () -> ((CancellableTask)((CancellableTask)task)).isCancelled(), request.source().aggregations(), b -> {});
                }
            };
            ActionListener.respondAndRelease((ActionListener)listener, (RefCounted)TransportRollupSearchAction.processResponses(rollupSearchContext, msearchResponse, reduceContextBuilder));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static SearchResponse processResponses(RollupSearchContext rollupContext, MultiSearchResponse msearchResponse, AggregationReduceContext.Builder reduceContextBuilder) throws Exception {
        if (rollupContext.hasLiveIndices() && rollupContext.hasRollupIndices()) {
            return RollupResponseTranslator.combineResponses(msearchResponse, reduceContextBuilder);
        }
        if (rollupContext.hasLiveIndices()) {
            assert (msearchResponse.getResponses().length == 1);
            SearchResponse res = RollupResponseTranslator.verifyResponse(msearchResponse.getResponses()[0]);
            res.mustIncRef();
            return res;
        }
        if (rollupContext.hasRollupIndices()) {
            return RollupResponseTranslator.translateResponse(msearchResponse, reduceContextBuilder);
        }
        throw new RuntimeException("MSearch response was empty, cannot unroll RollupSearch results");
    }

    static MultiSearchRequest createMSearchRequest(SearchRequest request, NamedWriteableRegistry registry, RollupSearchContext context) {
        if (!context.hasLiveIndices() && !context.hasRollupIndices()) {
            throw new IllegalArgumentException("Must specify at least one rollup index in _rollup_search API");
        }
        if (context.hasLiveIndices() && !context.hasRollupIndices()) {
            logger.debug("Creating msearch with only normal request");
            SearchRequest originalRequest = new SearchRequest(context.getLiveIndices(), request.source());
            return new MultiSearchRequest().add(originalRequest);
        }
        TransportRollupSearchAction.validateSearchRequest(request);
        SearchRequest originalRequest = new SearchRequest(context.getLiveIndices(), request.source());
        MultiSearchRequest msearch = new MultiSearchRequest();
        if (context.hasLiveIndices()) {
            msearch.add(originalRequest);
        }
        SearchSourceBuilder rolledSearchSource = new SearchSourceBuilder();
        rolledSearchSource.size(0);
        AggregatorFactories.Builder sourceAgg = request.source().aggregations();
        if (sourceAgg == null || sourceAgg.count() == 0) {
            msearch.add(new SearchRequest(context.getRollupIndices(), request.source()));
            return msearch;
        }
        HashSet<RollupJobCaps> validatedCaps = new HashSet<RollupJobCaps>();
        sourceAgg.getAggregatorFactories().forEach(agg -> validatedCaps.addAll(RollupJobIdentifierUtils.findBestJobs(agg, context.getJobCaps())));
        List<String> jobIds = validatedCaps.stream().map(RollupJobCaps::getJobID).toList();
        for (AggregationBuilder agg2 : sourceAgg.getAggregatorFactories()) {
            ArrayList filterConditions = new ArrayList(5);
            List<AggregationBuilder> translatedAgg = RollupRequestTranslator.translateAggregation(agg2, registry);
            BoolQueryBuilder boolQuery = new BoolQueryBuilder();
            filterConditions.forEach(arg_0 -> ((BoolQueryBuilder)boolQuery).must(arg_0));
            FilterAggregationBuilder filterAgg = new FilterAggregationBuilder("filter_" + agg2.getName(), (QueryBuilder)boolQuery);
            translatedAgg.forEach(arg_0 -> ((FilterAggregationBuilder)filterAgg).subAggregation(arg_0));
            rolledSearchSource.aggregation((AggregationBuilder)filterAgg);
        }
        QueryBuilder rewritten = TransportRollupSearchAction.rewriteQuery(request.source().query(), validatedCaps);
        for (String id : jobIds) {
            SearchSourceBuilder copiedSource;
            try {
                copiedSource = TransportRollupSearchAction.copyWriteable(rolledSearchSource, registry, (Writeable.Reader<SearchSourceBuilder>)((Writeable.Reader)SearchSourceBuilder::new));
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered IO exception while trying to build rollup request.", e);
            }
            copiedSource.query((QueryBuilder)new BoolQueryBuilder().must(rewritten).filter((QueryBuilder)new TermQueryBuilder(RollupField.formatMetaField((String)RollupField.ID.getPreferredName()), id)).filter((QueryBuilder)new TermsQueryBuilder(RollupField.formatMetaField((String)"version"), new long[]{1L, 2L})));
            msearch.add(new SearchRequest(context.getRollupIndices(), copiedSource));
        }
        return msearch;
    }

    private static SearchSourceBuilder copyWriteable(SearchSourceBuilder original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<SearchSourceBuilder> reader) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            SearchSourceBuilder searchSourceBuilder;
            output.setTransportVersion(TransportVersion.current());
            original.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                in.setTransportVersion(TransportVersion.current());
                searchSourceBuilder = (SearchSourceBuilder)reader.read((StreamInput)in);
            }
            return searchSourceBuilder;
        }
    }

    static void validateSearchRequest(SearchRequest request) {
        if (request.source().size() != 0) {
            throw new IllegalArgumentException("Rollup does not support returning search hits, please try again with [size: 0].");
        }
        if (request.source().postFilter() != null) {
            throw new IllegalArgumentException("Rollup search does not support post filtering.");
        }
        if (request.source().suggest() != null) {
            throw new IllegalArgumentException("Rollup search does not support suggestors.");
        }
        if (request.source().highlighter() != null) {
            throw new IllegalArgumentException("Rollup search does not support highlighting.");
        }
        if (request.source().profile()) {
            throw new IllegalArgumentException("Rollup search does not support profiling at the moment.");
        }
        if (request.source().explain() != null && request.source().explain().booleanValue()) {
            throw new IllegalArgumentException("Rollup search does not support explaining.");
        }
    }

    static QueryBuilder rewriteQuery(QueryBuilder builder, Set<RollupJobCaps> jobCaps) {
        if (builder == null) {
            return new MatchAllQueryBuilder();
        }
        if (builder.getWriteableName().equals("bool")) {
            BoolQueryBuilder rewrittenBool = new BoolQueryBuilder();
            ((BoolQueryBuilder)builder).must().forEach(query -> rewrittenBool.must(TransportRollupSearchAction.rewriteQuery(query, jobCaps)));
            ((BoolQueryBuilder)builder).mustNot().forEach(query -> rewrittenBool.mustNot(TransportRollupSearchAction.rewriteQuery(query, jobCaps)));
            ((BoolQueryBuilder)builder).should().forEach(query -> rewrittenBool.should(TransportRollupSearchAction.rewriteQuery(query, jobCaps)));
            ((BoolQueryBuilder)builder).filter().forEach(query -> rewrittenBool.filter(TransportRollupSearchAction.rewriteQuery(query, jobCaps)));
            return rewrittenBool;
        }
        if (builder.getWriteableName().equals("constant_score")) {
            return new ConstantScoreQueryBuilder(TransportRollupSearchAction.rewriteQuery(((ConstantScoreQueryBuilder)builder).innerQuery(), jobCaps));
        }
        if (builder.getWriteableName().equals("boosting")) {
            return new BoostingQueryBuilder(TransportRollupSearchAction.rewriteQuery(((BoostingQueryBuilder)builder).negativeQuery(), jobCaps), TransportRollupSearchAction.rewriteQuery(((BoostingQueryBuilder)builder).positiveQuery(), jobCaps));
        }
        if (builder.getWriteableName().equals("dis_max")) {
            DisMaxQueryBuilder rewritten = new DisMaxQueryBuilder();
            ((DisMaxQueryBuilder)builder).innerQueries().forEach(query -> rewritten.add(TransportRollupSearchAction.rewriteQuery(query, jobCaps)));
            return rewritten;
        }
        if (builder.getWriteableName().equals("range")) {
            RangeQueryBuilder range = (RangeQueryBuilder)builder;
            String fieldName = range.fieldName();
            String rewrittenFieldName = TransportRollupSearchAction.rewriteFieldName(jobCaps, "range", fieldName);
            RangeQueryBuilder rewritten = new RangeQueryBuilder(rewrittenFieldName).from(range.from()).to(range.to()).includeLower(range.includeLower()).includeUpper(range.includeUpper());
            if (range.timeZone() != null) {
                rewritten.timeZone(range.timeZone());
            }
            if (range.format() != null) {
                rewritten.format(range.format());
            }
            return rewritten;
        }
        if (builder.getWriteableName().equals("term")) {
            TermQueryBuilder term = (TermQueryBuilder)builder;
            String fieldName = term.fieldName();
            String rewrittenFieldName = TransportRollupSearchAction.rewriteFieldName(jobCaps, "term", fieldName);
            return new TermQueryBuilder(rewrittenFieldName, term.value());
        }
        if (builder.getWriteableName().equals("terms")) {
            TermsQueryBuilder terms = (TermsQueryBuilder)builder;
            String fieldName = terms.fieldName();
            String rewrittenFieldName = TransportRollupSearchAction.rewriteFieldName(jobCaps, "term", fieldName);
            return new TermsQueryBuilder(rewrittenFieldName, (Collection)terms.getValues());
        }
        if (builder.getWriteableName().equals("match_all")) {
            return builder;
        }
        throw new IllegalArgumentException("Unsupported Query in search request: [" + builder.getWriteableName() + "]");
    }

    private static String rewriteFieldName(Set<RollupJobCaps> jobCaps, String builderName, String fieldName) {
        List rewrittenFieldNames = jobCaps.stream().filter(caps -> caps.getFieldCaps().keySet().contains(fieldName)).map(caps -> {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)caps.getFieldCaps().get(fieldName);
            return fieldCaps.getAggs().stream().filter(agg -> {
                String type = (String)agg.get("agg");
                return type.equals("terms") || type.equals("date_histogram") || type.equals("histogram");
            }).map(agg -> {
                if (agg.get("agg").equals("date_histogram")) {
                    return RollupField.formatFieldName((String)fieldName, (String)((String)agg.get("agg")), (String)"timestamp");
                }
                return RollupField.formatFieldName((String)fieldName, (String)((String)agg.get("agg")), (String)"value");
            }).collect(Collectors.toList());
        }).distinct().collect(ArrayList::new, List::addAll, List::addAll);
        if (rewrittenFieldNames.isEmpty()) {
            throw new IllegalArgumentException("Field [" + fieldName + "] in [" + builderName + "] query is not available in selected rollup indices, cannot query.");
        }
        if (rewrittenFieldNames.size() > 1) {
            throw new IllegalArgumentException("Ambiguous field name resolution when mapping to rolled fields.  Field name [" + fieldName + "] was mapped to: [" + org.elasticsearch.common.Strings.collectionToDelimitedString((Iterable)rewrittenFieldNames, (String)",") + "].");
        }
        return (String)rewrittenFieldNames.get(0);
    }

    static RollupSearchContext separateIndices(String[] indices, Map<String, IndexMetadata> indexMetadata) {
        if (indices.length == 0) {
            throw new IllegalArgumentException("Must specify at least one concrete index.");
        }
        ArrayList rollup = new ArrayList();
        ArrayList normal = new ArrayList();
        HashSet<RollupJobCaps> jobCaps = new HashSet<RollupJobCaps>();
        Arrays.stream(indices).forEach(i -> {
            if (i.equals("_all")) {
                throw new IllegalArgumentException("Searching _all via RollupSearch endpoint is not supported at this time.");
            }
            Optional<RollupIndexCaps> caps = TransportGetRollupCapsAction.findRollupIndexCaps(i, (IndexMetadata)indexMetadata.get(i));
            if (caps.isPresent()) {
                rollup.add(i);
                jobCaps.addAll(caps.get().getJobCaps());
            } else {
                normal.add(i);
            }
        });
        assert (normal.size() + rollup.size() > 0);
        if (rollup.size() > 1) {
            throw new IllegalArgumentException("RollupSearch currently only supports searching one rollup index at a time. Found the following rollup indices: " + rollup);
        }
        return new RollupSearchContext(normal.toArray(new String[0]), rollup.toArray(new String[0]), jobCaps);
    }

    class TransportHandler
    implements TransportRequestHandler<SearchRequest> {
        TransportHandler() {
        }

        public final void messageReceived(final SearchRequest request, final TransportChannel channel, Task task) throws Exception {
            TransportRollupSearchAction.this.execute(task, (ActionRequest)request, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                    finally {
                        response.decRef();
                    }
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        logger.warn(() -> Strings.format((String)"Failed to send error response for action [%s] and request [%s]", (Object[])new Object[]{TransportRollupSearchAction.this.actionName, request}), (Throwable)e1);
                    }
                }
            });
        }
    }

    static class RollupSearchContext {
        private final String[] liveIndices;
        private final String[] rollupIndices;
        private final Set<RollupJobCaps> jobCaps;

        RollupSearchContext(String[] liveIndices, String[] rollupIndices, Set<RollupJobCaps> jobCaps) {
            this.liveIndices = Objects.requireNonNull(liveIndices);
            this.rollupIndices = Objects.requireNonNull(rollupIndices);
            this.jobCaps = Objects.requireNonNull(jobCaps);
        }

        boolean hasLiveIndices() {
            return this.liveIndices.length != 0;
        }

        boolean hasRollupIndices() {
            return this.rollupIndices.length != 0;
        }

        String[] getLiveIndices() {
            return this.liveIndices;
        }

        String[] getRollupIndices() {
            return this.rollupIndices;
        }

        Set<RollupJobCaps> getJobCaps() {
            return this.jobCaps;
        }
    }
}

