/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.rollup.action.GetRollupCapsAction;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.rollup.action.RollupIndexCaps;

public class TransportGetRollupCapsAction
extends HandledTransportAction<GetRollupCapsAction.Request, GetRollupCapsAction.Response> {
    private final ClusterService clusterService;
    private final Executor managementExecutor;

    @Inject
    public TransportGetRollupCapsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:monitor/xpack/rollup/get/caps", transportService, actionFilters, GetRollupCapsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.managementExecutor = transportService.getThreadPool().executor("management");
    }

    protected void doExecute(Task task, GetRollupCapsAction.Request request, ActionListener<GetRollupCapsAction.Response> listener) {
        this.managementExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(request.getIndexPattern(), (ActionListener<GetRollupCapsAction.Response>)l)));
    }

    private void doExecuteForked(String indexPattern, ActionListener<GetRollupCapsAction.Response> listener) {
        Transports.assertNotTransportThread((String)"retrieving rollup job caps may be expensive");
        Map<String, RollableIndexCaps> allCaps = TransportGetRollupCapsAction.getCaps(indexPattern, this.clusterService.state().getMetadata().indices());
        listener.onResponse((Object)new GetRollupCapsAction.Response(allCaps));
    }

    static Map<String, RollableIndexCaps> getCaps(String indexPattern, Map<String, IndexMetadata> indices) {
        TreeMap allCaps = new TreeMap();
        for (Map.Entry<String, IndexMetadata> entry : indices.entrySet()) {
            TransportGetRollupCapsAction.findRollupIndexCaps(entry.getKey(), entry.getValue()).ifPresent(cap -> {
                List<RollupJobCaps> jobCaps = indexPattern.equals("_all") ? cap.getJobCaps() : cap.getJobCapsByIndexPattern(indexPattern);
                jobCaps.forEach(jobCap -> {
                    String pattern = indexPattern.equals("_all") ? jobCap.getIndexPattern() : indexPattern;
                    ArrayList<RollupJobCaps> indexCaps = (ArrayList<RollupJobCaps>)allCaps.get(pattern);
                    if (indexCaps == null) {
                        indexCaps = new ArrayList<RollupJobCaps>();
                    }
                    indexCaps.add((RollupJobCaps)jobCap);
                    allCaps.put(pattern, indexCaps);
                });
            });
        }
        return allCaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RollableIndexCaps((String)e.getKey(), (List)e.getValue())));
    }

    static Optional<RollupIndexCaps> findRollupIndexCaps(String indexName, IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            return Optional.empty();
        }
        MappingMetadata rollupMapping = indexMetadata.mapping();
        if (rollupMapping == null) {
            return Optional.empty();
        }
        Object objMeta = rollupMapping.getSourceAsMap().get("_meta");
        if (objMeta == null) {
            return Optional.empty();
        }
        RollupIndexCaps caps = RollupIndexCaps.parseMetadataXContent(rollupMapping.source().uncompressed(), indexName);
        if (caps.hasCaps()) {
            return Optional.of(caps);
        }
        return Optional.empty();
    }
}

