/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class TraceEvent {
    final String stacktraceID;
    double annualCO2Tons;
    double annualCostsUSD;
    long count;
    final Map<String, Long> subGroups = new HashMap<String, Long>();

    TraceEvent(String stacktraceID) {
        this(stacktraceID, 0L);
    }

    TraceEvent(String stacktraceID, long count) {
        this.stacktraceID = stacktraceID;
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceEvent event = (TraceEvent)o;
        return this.count == event.count && Objects.equals(this.stacktraceID, event.stacktraceID);
    }

    public int hashCode() {
        return Objects.hash(this.stacktraceID, this.count);
    }

    public String toString() {
        return "TraceEvent{stacktraceID='" + this.stacktraceID + "', annualCO2Tons=" + this.annualCO2Tons + ", annualCostsUSD=" + this.annualCostsUSD + ", count=" + this.count + ", subGroups=" + this.subGroups + "}";
    }
}

