/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.application.ProfilingUsage;
import org.elasticsearch.xpack.profiling.action.ProfilingLicenseChecker;

public class ProfilingUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final ProfilingLicenseChecker licenseChecker;
    private final boolean enabled;

    @Inject
    public ProfilingUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProfilingLicenseChecker licenseChecker, Settings settings) {
        super(XPackUsageFeatureAction.UNIVERSAL_PROFILING.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.licenseChecker = licenseChecker;
        this.enabled = (Boolean)XPackSettings.PROFILING_ENABLED.get(settings);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        ProfilingUsage profilingUsage = new ProfilingUsage(this.licenseChecker.isSupportedLicense(), this.enabled);
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)profilingUsage));
    }
}

