/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.profiling.action.StackFrame;
import org.elasticsearch.xpack.profiling.action.StackTrace;
import org.elasticsearch.xpack.profiling.action.TraceEvent;

public class GetStackTracesResponse
extends ActionResponse
implements ChunkedToXContentObject {
    @Nullable
    private final Map<String, StackTrace> stackTraces;
    @Nullable
    private final Map<String, StackFrame> stackFrames;
    @Nullable
    private final Map<String, String> executables;
    @Nullable
    private final Map<String, TraceEvent> stackTraceEvents;
    private final int totalFrames;
    private final double samplingRate;
    private final long totalSamples;

    public GetStackTracesResponse(Map<String, StackTrace> stackTraces, Map<String, StackFrame> stackFrames, Map<String, String> executables, Map<String, TraceEvent> stackTraceEvents, int totalFrames, double samplingRate, long totalSamples) {
        this.stackTraces = stackTraces;
        this.stackFrames = stackFrames;
        this.executables = executables;
        this.stackTraceEvents = stackTraceEvents;
        this.totalFrames = totalFrames;
        this.samplingRate = samplingRate;
        this.totalSamples = totalSamples;
    }

    public void writeTo(StreamOutput out) {
        TransportAction.localOnly();
    }

    public Map<String, StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public Map<String, String> getExecutables() {
        return this.executables;
    }

    public Map<String, TraceEvent> getStackTraceEvents() {
        return this.stackTraceEvents;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), GetStackTracesResponse.optional("stack_traces", this.stackTraces, ChunkedToXContentHelper::xContentValuesMap), GetStackTracesResponse.optional("stack_frames", this.stackFrames, ChunkedToXContentHelper::xContentValuesMap), GetStackTracesResponse.optional("executables", this.executables, ChunkedToXContentHelper::map), GetStackTracesResponse.optional("stack_trace_events", this.stackTraceEvents, (n, v) -> ChunkedToXContentHelper.map((String)n, (Map)v, entry -> (b, p) -> b.field((String)entry.getKey(), ((TraceEvent)entry.getValue()).count))), Iterators.single((b, p) -> b.field("total_frames", this.totalFrames)), Iterators.single((b, p) -> b.field("sampling_rate", this.samplingRate)), ChunkedToXContentHelper.endObject()});
    }

    private static <T> Iterator<? extends ToXContent> optional(String name, Map<String, T> values, BiFunction<String, Map<String, T>, Iterator<? extends ToXContent>> supplier) {
        return values != null ? supplier.apply(name, values) : Collections.emptyIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetStackTracesResponse response = (GetStackTracesResponse)((Object)o);
        return this.totalFrames == response.totalFrames && this.samplingRate == response.samplingRate && Objects.equals(this.stackTraces, response.stackTraces) && Objects.equals(this.stackFrames, response.stackFrames) && Objects.equals(this.executables, response.executables) && Objects.equals(this.stackTraceEvents, response.stackTraceEvents);
    }

    public int hashCode() {
        return Objects.hash(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.samplingRate);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this, (boolean)true, (boolean)true);
    }
}

