/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.core.Nullable;

public abstract class BlobCacheBufferedIndexInput
extends IndexInput
implements RandomAccessInput {
    private static final ByteBuffer EMPTY_BYTEBUFFER = ByteBuffer.allocate(0).order(ByteOrder.LITTLE_ENDIAN);
    public static final int BUFFER_SIZE = 1024;
    public static final int MIN_BUFFER_SIZE = 8;
    public static final int MERGE_BUFFER_SIZE = 4096;
    private final long length;
    private final int bufferSize;
    protected ByteBuffer buffer = EMPTY_BYTEBUFFER;
    private long bufferStart = 0L;

    public final byte readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.refill();
        }
        return this.buffer.get();
    }

    public BlobCacheBufferedIndexInput(String resourceDesc, IOContext context, long length) {
        this(resourceDesc, BlobCacheBufferedIndexInput.bufferSize(context), length);
    }

    public BlobCacheBufferedIndexInput(String resourceDesc, int bufferSize, long length) {
        super(resourceDesc);
        int bufSize = Math.max(8, (int)Math.min((long)bufferSize, length));
        this.checkBufferSize(bufSize);
        this.bufferSize = bufSize;
        this.length = length;
    }

    public final long length() {
        return this.length;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("bufferSize must be at least MIN_BUFFER_SIZE (got " + bufferSize + ")");
        }
    }

    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        this.readBytes(b, offset, len, true);
    }

    public final void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        int available = this.buffer.remaining();
        if (len <= available) {
            if (len > 0) {
                this.buffer.get(b, offset, len);
            }
        } else {
            if (available > 0) {
                this.buffer.get(b, offset, available);
                offset += available;
                len -= available;
            }
            if (useBuffer && len < this.bufferSize) {
                this.refill();
                if (this.buffer.remaining() < len) {
                    this.buffer.get(b, offset, this.buffer.remaining());
                    throw new EOFException("read past EOF: " + this);
                }
                this.buffer.get(b, offset, len);
            } else {
                long after;
                if (this.buffer == EMPTY_BYTEBUFFER) {
                    this.seekInternal(this.bufferStart);
                }
                if ((after = this.bufferStart + (long)this.buffer.position() + (long)len) > this.length()) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.readInternal(ByteBuffer.wrap(b, offset, len));
                this.bufferStart = after;
                this.buffer.limit(0);
            }
        }
    }

    public final short readShort() throws IOException {
        if (2 <= this.buffer.remaining()) {
            return this.buffer.getShort();
        }
        return super.readShort();
    }

    public final int readInt() throws IOException {
        if (4 <= this.buffer.remaining()) {
            return this.buffer.getInt();
        }
        return super.readInt();
    }

    public final long readLong() throws IOException {
        if (8 <= this.buffer.remaining()) {
            return this.buffer.getLong();
        }
        return super.readLong();
    }

    public final int readVInt() throws IOException {
        if (5 <= this.buffer.remaining()) {
            return ByteBufferStreamInput.readVInt((ByteBuffer)this.buffer);
        }
        return super.readVInt();
    }

    public final long readVLong() throws IOException {
        if (9 <= this.buffer.remaining()) {
            return ByteBufferStreamInput.readVLong((ByteBuffer)this.buffer);
        }
        return super.readVLong();
    }

    private long resolvePositionInBuffer(long pos, int width) throws IOException {
        long index = pos - this.bufferStart;
        if (index >= 0L && index <= (long)(this.buffer.limit() - width)) {
            return index;
        }
        if (index < 0L) {
            this.bufferStart = Math.max(this.bufferStart - (long)this.bufferSize, pos + (long)width - (long)this.bufferSize);
            this.bufferStart = Math.max(this.bufferStart, 0L);
            this.bufferStart = Math.min(this.bufferStart, pos);
        } else {
            this.bufferStart = pos;
        }
        this.buffer.limit(0);
        this.seekInternal(this.bufferStart);
        this.refill();
        return pos - this.bufferStart;
    }

    public final byte readByte(long pos) throws IOException {
        long index = this.resolvePositionInBuffer(pos, 1);
        return this.buffer.get((int)index);
    }

    public final short readShort(long pos) throws IOException {
        long index = this.resolvePositionInBuffer(pos, 2);
        return this.buffer.getShort((int)index);
    }

    public final int readInt(long pos) throws IOException {
        long index = this.resolvePositionInBuffer(pos, 4);
        return this.buffer.getInt((int)index);
    }

    public final long readLong(long pos) throws IOException {
        long index = this.resolvePositionInBuffer(pos, 8);
        return this.buffer.getLong((int)index);
    }

    public void readFloats(float[] dst, int offset, int len) throws IOException {
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 4, remainingDst);
            this.buffer.asFloatBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.position() + 4 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = Float.intBitsToFloat(this.readInt());
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    public void readLongs(long[] dst, int offset, int len) throws IOException {
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 8, remainingDst);
            this.buffer.asLongBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.position() + 8 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = this.readLong();
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    public void readInts(int[] dst, int offset, int len) throws IOException {
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 4, remainingDst);
            this.buffer.asIntBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.position() + 4 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = this.readInt();
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    protected void refill() throws IOException {
        int newLength;
        long start = this.bufferStart + (long)this.buffer.position();
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        if ((newLength = (int)(end - start)) <= 0) {
            throw new EOFException("read past EOF: " + this);
        }
        if (this.buffer == EMPTY_BYTEBUFFER) {
            this.buffer = ByteBuffer.allocate(this.bufferSize).order(ByteOrder.LITTLE_ENDIAN);
            this.seekInternal(this.bufferStart);
        }
        this.buffer.position(0);
        this.buffer.limit(newLength);
        this.bufferStart = start;
        this.readInternal(this.buffer);
        assert (this.buffer.order() == ByteOrder.LITTLE_ENDIAN) : this.buffer.order();
        assert (this.buffer.remaining() == 0) : "should have thrown EOFException";
        assert (this.buffer.position() == newLength);
        this.buffer.flip();
    }

    protected abstract void readInternal(ByteBuffer var1) throws IOException;

    public final long getFilePointer() {
        return this.bufferStart + (long)this.buffer.position();
    }

    public final void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.buffer.limit()) {
            this.buffer.position((int)(pos - this.bufferStart));
        } else {
            this.bufferStart = pos;
            this.buffer.limit(0);
            this.seekInternal(pos);
        }
    }

    @Nullable
    protected final IndexInput trySliceBuffer(String name, long sliceOffset, long sliceLength) {
        if (ByteRange.of(this.bufferStart, this.bufferStart + (long)this.buffer.limit()).contains(sliceOffset, sliceOffset + sliceLength)) {
            byte[] bytes = new byte[(int)sliceLength];
            this.buffer.get(Math.toIntExact(sliceOffset - this.bufferStart), bytes, 0, bytes.length);
            return new ByteArrayIndexInput(name, bytes);
        }
        return null;
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public BlobCacheBufferedIndexInput clone() {
        BlobCacheBufferedIndexInput clone = (BlobCacheBufferedIndexInput)super.clone();
        clone.buffer = EMPTY_BYTEBUFFER;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }

    public static int bufferSize(IOContext context) {
        switch (context.context) {
            case MERGE: {
                return 4096;
            }
        }
        return 1024;
    }
}

