/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.h3.Vec2d;

final class CoordIJK {
    private static final int[][] UNIT_VECS = new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}, {0, 1, 1}, {1, 0, 0}, {1, 0, 1}, {1, 1, 0}};
    int i;
    int j;
    int k;

    CoordIJK(int i, int j, int k) {
        this.i = i;
        this.j = j;
        this.k = k;
    }

    void reset(int i, int j, int k) {
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public Vec2d ijkToHex2d() {
        int i = Math.subtractExact(this.i, this.k);
        int j = Math.subtractExact(this.j, this.k);
        return new Vec2d((double)i - 0.5 * (double)j, (double)j * Constants.M_SQRT3_2);
    }

    public LatLng ijkToGeo(int face, int res, boolean substrate) {
        int i = Math.subtractExact(this.i, this.k);
        int j = Math.subtractExact(this.j, this.k);
        return Vec2d.hex2dToGeo((double)i - 0.5 * (double)j, (double)j * Constants.M_SQRT3_2, face, res, substrate);
    }

    public void ijkAdd(int i, int j, int k) {
        this.i = Math.addExact(this.i, i);
        this.j = Math.addExact(this.j, j);
        this.k = Math.addExact(this.k, k);
    }

    public void ijkSub(int i, int j, int k) {
        this.i = Math.subtractExact(this.i, i);
        this.j = Math.subtractExact(this.j, j);
        this.k = Math.subtractExact(this.k, k);
    }

    public void ijkNormalize() {
        int min = Math.min(this.i, Math.min(this.j, this.k));
        this.ijkSub(min, min, min);
    }

    public void downAp7() {
        int i = Math.addExact(Math.multiplyExact(this.i, 3), this.j);
        int j = Math.addExact(Math.multiplyExact(this.j, 3), this.k);
        int k = Math.addExact(Math.multiplyExact(this.k, 3), this.i);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp7r() {
        int i = Math.addExact(Math.multiplyExact(this.i, 3), this.k);
        int j = Math.addExact(Math.multiplyExact(this.j, 3), this.i);
        int k = Math.addExact(Math.multiplyExact(this.k, 3), this.j);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp3() {
        int i = Math.addExact(Math.multiplyExact(this.i, 2), this.j);
        int j = Math.addExact(Math.multiplyExact(this.j, 2), this.k);
        int k = Math.addExact(Math.multiplyExact(this.k, 2), this.i);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp3r() {
        int i = Math.addExact(Math.multiplyExact(this.i, 2), this.k);
        int j = Math.addExact(Math.multiplyExact(this.j, 2), this.i);
        int k = Math.addExact(Math.multiplyExact(this.k, 2), this.j);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void ijkRotate60cw() {
        int i = Math.addExact(this.i, this.j);
        int j = Math.addExact(this.j, this.k);
        int k = Math.addExact(this.i, this.k);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void ijkRotate60ccw() {
        int i = Math.addExact(this.i, this.k);
        int j = Math.addExact(this.i, this.j);
        int k = Math.addExact(this.j, this.k);
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void neighbor(int digit) {
        if (digit > Direction.CENTER_DIGIT.digit() && digit < Direction.NUM_DIGITS.digit()) {
            this.ijkAdd(UNIT_VECS[digit][0], UNIT_VECS[digit][1], UNIT_VECS[digit][2]);
            this.ijkNormalize();
        }
    }

    public void upAp7r() {
        int i = Math.subtractExact(this.i, this.k);
        int j = Math.subtractExact(this.j, this.k);
        this.i = (int)Math.round((double)Math.addExact(Math.multiplyExact(2, i), j) / 7.0);
        this.j = (int)Math.round((double)Math.subtractExact(Math.multiplyExact(3, j), i) / 7.0);
        this.k = 0;
        this.ijkNormalize();
    }

    public void upAp7() {
        int i = Math.subtractExact(this.i, this.k);
        int j = Math.subtractExact(this.j, this.k);
        this.i = (int)Math.round((double)Math.subtractExact(Math.multiplyExact(3, i), j) / 7.0);
        this.j = (int)Math.round((double)Math.addExact(Math.multiplyExact(2, j), i) / 7.0);
        this.k = 0;
        this.ijkNormalize();
    }

    public int unitIjkToDigit() {
        if (Math.min(this.i, Math.min(this.j, this.k)) < 0 || Math.max(this.i, Math.max(this.j, this.k)) > 1) {
            return Direction.INVALID_DIGIT.digit();
        }
        return this.i << 2 | this.j << 1 | this.k;
    }

    public static int rotate60cw(int digit) {
        return switch (digit) {
            case 1 -> Direction.JK_AXES_DIGIT.digit();
            case 3 -> Direction.J_AXES_DIGIT.digit();
            case 2 -> Direction.IJ_AXES_DIGIT.digit();
            case 6 -> Direction.I_AXES_DIGIT.digit();
            case 4 -> Direction.IK_AXES_DIGIT.digit();
            case 5 -> Direction.K_AXES_DIGIT.digit();
            default -> digit;
        };
    }

    public static int rotate60ccw(int digit) {
        return switch (digit) {
            case 1 -> Direction.IK_AXES_DIGIT.digit();
            case 5 -> Direction.I_AXES_DIGIT.digit();
            case 4 -> Direction.IJ_AXES_DIGIT.digit();
            case 6 -> Direction.J_AXES_DIGIT.digit();
            case 2 -> Direction.JK_AXES_DIGIT.digit();
            case 3 -> Direction.K_AXES_DIGIT.digit();
            default -> digit;
        };
    }

    public static enum Direction {
        CENTER_DIGIT(0),
        K_AXES_DIGIT(1),
        J_AXES_DIGIT(2),
        JK_AXES_DIGIT(J_AXES_DIGIT.digit() | K_AXES_DIGIT.digit()),
        I_AXES_DIGIT(4),
        IK_AXES_DIGIT(I_AXES_DIGIT.digit() | K_AXES_DIGIT.digit()),
        IJ_AXES_DIGIT(I_AXES_DIGIT.digit() | J_AXES_DIGIT.digit()),
        INVALID_DIGIT(7),
        NUM_DIGITS(INVALID_DIGIT.digit()),
        PENTAGON_SKIPPED_DIGIT(K_AXES_DIGIT.digit());

        private final int digit;

        private Direction(int digit) {
            this.digit = digit;
        }

        public int digit() {
            return this.digit;
        }
    }
}

