/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.scheduling;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduledTask;

class TransformScheduledTaskQueue {
    private static final Logger logger = LogManager.getLogger(TransformScheduledTaskQueue.class);
    private final SortedSet<TransformScheduledTask> tasks = new TreeSet<TransformScheduledTask>(Comparator.comparing(TransformScheduledTask::getNextScheduledTimeMillis).thenComparing(TransformScheduledTask::getTransformId));
    private final Map<String, TransformScheduledTask> tasksById = new HashMap<String, TransformScheduledTask>();

    TransformScheduledTaskQueue() {
    }

    public synchronized TransformScheduledTask first() {
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.first();
    }

    public synchronized boolean add(TransformScheduledTask task) {
        String transformId = task.getTransformId();
        logger.trace("add({}): {}", (Object)transformId, (Object)task);
        if (this.tasksById.containsKey(transformId)) {
            logger.debug("add({}) is a no-op as the task for this transform already exists", (Object)transformId);
            return false;
        }
        this.tasksById.put(transformId, task);
        this.tasks.add(task);
        return true;
    }

    public synchronized void update(String transformId, Function<TransformScheduledTask, TransformScheduledTask> transformer) {
        TransformScheduledTask task = this.remove(transformId);
        if (task == null) {
            return;
        }
        TransformScheduledTask updatedTask = transformer.apply(task);
        if (!transformId.equals(updatedTask.getTransformId())) {
            throw new IllegalStateException("Must not modify the transform's id during update");
        }
        this.add(updatedTask);
    }

    public synchronized TransformScheduledTask remove(String transformId) {
        logger.trace("remove({})", (Object)transformId);
        TransformScheduledTask task = this.tasksById.remove(transformId);
        if (task == null) {
            logger.debug("remove({}) is a no-op as the task for this transform does not exist", (Object)transformId);
            return null;
        }
        this.tasks.remove(task);
        return task;
    }

    synchronized Set<String> getTransformIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.tasksById.keySet()));
    }

    synchronized List<TransformScheduledTask> listScheduledTasks() {
        return this.tasks.stream().toList();
    }
}

