/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformDeprecations;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.TransformExtension;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;
import org.elasticsearch.xpack.transform.transforms.CannotStartFailedTransformException;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexerBuilder;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformRetryableStartUpListener;
import org.elasticsearch.xpack.transform.transforms.TransformTask;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

public class TransformPersistentTasksExecutor
extends PersistentTasksExecutor<TransformTaskParams> {
    private static final Logger logger = LogManager.getLogger(TransformPersistentTasksExecutor.class);
    private static final int MARK_AS_FAILED_TIMEOUT_SEC = 90;
    private final Client client;
    private final TransformServices transformServices;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final TransformAuditor auditor;
    private final TransformExtension transformExtension;
    private volatile int numFailureRetries;

    public TransformPersistentTasksExecutor(Client client, TransformServices transformServices, ThreadPool threadPool, ClusterService clusterService, Settings settings, TransformExtension transformExtension, IndexNameExpressionResolver resolver) {
        super("data_frame/transforms", (Executor)threadPool.generic());
        this.client = client;
        this.transformServices = transformServices;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditor = transformServices.getAuditor();
        this.numFailureRetries = (Integer)Transform.NUM_FAILURE_RETRIES_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(Transform.NUM_FAILURE_RETRIES_SETTING, this::setNumFailureRetries);
        this.transformExtension = transformExtension;
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(TransformTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        if (TransformMetadata.getTransformMetadata((ClusterState)clusterState).isResetMode()) {
            return new PersistentTasksCustomMetadata.Assignment(null, "Transform task will not be assigned as a feature reset is in progress.");
        }
        List<String> unavailableIndices = TransformPersistentTasksExecutor.verifyIndicesPrimaryShardsAreActive(clusterState, this.resolver);
        if (unavailableIndices.size() != 0) {
            String reason = "Not starting transform [" + params.getId() + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetadata.Assignment(null, reason);
        }
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, candidateNodes, node -> TransformNodes.nodeCanRunThisTransform(node, params.getVersion(), params.requiresRemote(), null));
        if (discoveryNode == null) {
            TreeMap<String, String> explainWhyAssignmentFailed = new TreeMap<String, String>();
            for (DiscoveryNode node2 : clusterState.getNodes()) {
                TransformNodes.nodeCanRunThisTransform(node2, params.getVersion(), params.requiresRemote(), explainWhyAssignmentFailed);
            }
            String reason = "Not starting transform [" + params.getId() + "], reasons [" + explainWhyAssignmentFailed.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining("|")) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetadata.Assignment(null, reason);
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, IndexNameExpressionResolver resolver) {
        String[] indices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{".transform-internal-*", ".data-frame-internal-*"});
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive() && routingTable.readyForSearch(clusterState)) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    protected void nodeOperation(AllocatedPersistentTask task, @Nullable TransformTaskParams params, PersistentTaskState state) {
        String transformId = params.getId();
        TransformTask buildTask = (TransformTask)task;
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, buildTask.getParentTaskId());
        ClientTransformIndexerBuilder indexerBuilder = new ClientTransformIndexerBuilder().setClient(parentTaskClient).setClusterService(this.clusterService).setIndexNameExpressionResolver(this.resolver).setTransformExtension(this.transformExtension).setTransformServices(this.transformServices);
        SetOnce stateHolder = new SetOnce();
        ActionListener startTaskListener = ActionListener.wrap(response -> logger.info("[{}] successfully completed and scheduled task in node operation", (Object)transformId), failure -> {
            boolean logErrorAsInfo = failure instanceof CannotStartFailedTransformException;
            this.auditor.audit(logErrorAsInfo ? Level.INFO : Level.ERROR, transformId, "Failed to start transform. Please stop and attempt to start again. Failure: " + failure.getMessage());
            logger.atLevel(logErrorAsInfo ? org.apache.logging.log4j.Level.INFO : org.apache.logging.log4j.Level.ERROR).withThrowable((Throwable)failure).log("[{}] Failed to start task in node operation", (Object)transformId);
        });
        ActionListener getTransformNextCheckpointListener = ActionListener.wrap(nextCheckpoint -> {
            if (nextCheckpoint.isEmpty()) {
                indexerBuilder.setInitialPosition(null);
                indexerBuilder.setProgress(null);
            } else {
                logger.trace("[{}] Loaded next checkpoint [{}] found, starting the task", (Object)transformId, (Object)nextCheckpoint.getCheckpoint());
                indexerBuilder.setNextCheckpoint((TransformCheckpoint)nextCheckpoint);
            }
            long lastCheckpoint = ((TransformState)stateHolder.get()).getCheckpoint();
            AuthorizationState authState = ((TransformState)stateHolder.get()).getAuthState();
            this.startTask(buildTask, indexerBuilder, authState, lastCheckpoint, (ActionListener<StartTransformAction.Response>)startTaskListener);
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            TransformPersistentTasksExecutor.markAsFailed(buildTask, error, msg);
        });
        ActionListener getTransformLastCheckpointListener = ActionListener.wrap(lastCheckpoint -> {
            indexerBuilder.setLastCheckpoint((TransformCheckpoint)lastCheckpoint);
            logger.trace("[{}] Loaded last checkpoint [{}], looking for next checkpoint", (Object)transformId, (Object)lastCheckpoint.getCheckpoint());
            this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint.getCheckpoint() + 1L, (ActionListener<TransformCheckpoint>)getTransformNextCheckpointListener);
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            TransformPersistentTasksExecutor.markAsFailed(buildTask, error, msg);
        });
        ActionListener transformStatsActionListener = ActionListener.wrap(stateAndStatsAndSeqNoPrimaryTermAndIndex -> {
            TransformStoredDoc stateAndStats = (TransformStoredDoc)stateAndStatsAndSeqNoPrimaryTermAndIndex.v1();
            SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = (SeqNoPrimaryTermAndIndex)stateAndStatsAndSeqNoPrimaryTermAndIndex.v2();
            logger.trace("[{}] initializing state and stats: [{}]", (Object)transformId, (Object)stateAndStats.toString());
            TransformState transformState = stateAndStats.getTransformState();
            indexerBuilder.setInitialStats(stateAndStats.getTransformStats()).setInitialPosition(stateAndStats.getTransformState().getPosition()).setProgress(stateAndStats.getTransformState().getProgress()).setIndexerState(TransformPersistentTasksExecutor.currentIndexerState(transformState)).setSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex).setShouldStopAtCheckpoint(transformState.shouldStopAtNextCheckpoint());
            logger.debug("[{}] Loading existing state: [{}], position [{}]", (Object)transformId, (Object)stateAndStats.getTransformState(), (Object)stateAndStats.getTransformState().getPosition());
            stateHolder.set((Object)transformState);
            long lastCheckpoint = ((TransformState)stateHolder.get()).getCheckpoint();
            if (lastCheckpoint == 0L) {
                logger.trace("[{}] No last checkpoint found, looking for next checkpoint", (Object)transformId);
                this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint + 1L, (ActionListener<TransformCheckpoint>)getTransformNextCheckpointListener);
            } else {
                logger.trace("[{}] Restore last checkpoint: [{}]", (Object)transformId, (Object)lastCheckpoint);
                this.transformServices.getConfigManager().getTransformCheckpoint(transformId, lastCheckpoint, (ActionListener<TransformCheckpoint>)getTransformLastCheckpointListener);
            }
        }, error -> {
            if (!(error instanceof ResourceNotFoundException)) {
                String msg = TransformMessages.getMessage((String)"Failed to load transform state for transform [{0}]", (Object[])new Object[]{transformId});
                logger.error(msg, (Throwable)error);
                TransformPersistentTasksExecutor.markAsFailed(buildTask, error, msg);
            } else {
                logger.trace("[{}] No stats found (new transform), starting the task", (Object)transformId);
                this.startTask(buildTask, indexerBuilder, null, null, (ActionListener<StartTransformAction.Response>)startTaskListener);
            }
        });
        ActionListener getTransformConfigListener = ActionListener.wrap(config -> {
            if (config.getVersion() == null || config.getVersion().before((VersionId)TransformDeprecations.MIN_TRANSFORM_VERSION)) {
                String transformTooOldError = Strings.format((String)"Transform configuration is too old [%s], use the upgrade API to fix your transform. Minimum required version is [%s]", (Object[])new Object[]{config.getVersion(), TransformDeprecations.MIN_TRANSFORM_VERSION});
                this.auditor.error(transformId, transformTooOldError);
                TransformPersistentTasksExecutor.markAsFailed(buildTask, null, transformTooOldError);
                return;
            }
            ActionRequestValidationException validationException = config.validate(null);
            if (validationException == null) {
                indexerBuilder.setTransformConfig((TransformConfig)config);
                this.transformServices.getConfigManager().getTransformStoredDoc(transformId, false, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)transformStatsActionListener);
            } else {
                this.auditor.error(transformId, validationException.getMessage());
                TransformPersistentTasksExecutor.markAsFailed(buildTask, (Throwable)validationException, TransformMessages.getMessage((String)"Transform configuration [{0}] has invalid elements: [{1}]", (Object[])new Object[]{transformId, validationException.getMessage()}));
            }
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform configuration for transform [{0}]", (Object[])new Object[]{transformId});
            TransformPersistentTasksExecutor.markAsFailed(buildTask, error, msg);
        });
        ActionListener<Void> templateCheckListener = this.getTransformConfig(buildTask, params, (ActionListener<TransformConfig>)getTransformConfigListener);
        TransformInternalIndex.createLatestVersionedIndexIfRequired(this.clusterService, (Client)parentTaskClient, this.transformExtension.getTransformInternalIndexAdditionalSettings(), (ActionListener<Void>)templateCheckListener.delegateResponse((l, e) -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            String msg = "Failed to create internal index mappings";
            TransformPersistentTasksExecutor.markAsFailed(buildTask, e, msg + "[" + cause + "]");
        }));
    }

    private static IndexerState currentIndexerState(TransformState previousState) {
        if (previousState == null) {
            return IndexerState.STOPPED;
        }
        return switch (previousState.getIndexerState()) {
            default -> throw new IncompatibleClassChangeError();
            case IndexerState.STARTED, IndexerState.INDEXING -> IndexerState.STARTED;
            case IndexerState.STOPPED, IndexerState.STOPPING, IndexerState.ABORTING -> IndexerState.STOPPED;
        };
    }

    private static void markAsFailed(TransformTask task, Throwable exception, String reason) {
        CountDownLatch latch = new CountDownLatch(1);
        task.fail(exception, reason, (ActionListener<Void>)new LatchedActionListener(ActionListener.wrap(nil -> {}, failure -> logger.error("Failed to set task [" + task.getTransformId() + "] to failed", (Throwable)failure)), latch));
        try {
            latch.await(90L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Timeout waiting for task [" + task.getTransformId() + "] to be marked as failed in cluster state", (Throwable)e);
        }
    }

    private ActionListener<Void> getTransformConfig(TransformTask task, TransformTaskParams params, ActionListener<TransformConfig> listener) {
        return ActionListener.running(() -> {
            String transformId = params.getId();
            TransformScheduler scheduler = this.transformServices.getScheduler();
            scheduler.registerTransform(params, new TransformRetryableStartUpListener(transformId, l -> this.transformServices.getConfigManager().getTransformConfiguration(transformId, (ActionListener<TransformConfig>)l), ActionListener.runBefore((ActionListener)listener, () -> scheduler.deregisterTransform(transformId)), this.retryListener(task), () -> true, task.getContext()));
        });
    }

    private ActionListener<Boolean> retryListener(TransformTask task) {
        return ActionListener.wrap(isRetrying -> {
            if (isRetrying.booleanValue()) {
                TransformState oldState = task.getState();
                TransformState newState = new TransformState(TransformTaskState.STARTED, oldState.getIndexerState(), oldState.getPosition(), oldState.getCheckpoint(), "Retrying transform start.", oldState.getProgress(), oldState.getNode(), oldState.shouldStopAtNextCheckpoint(), oldState.getAuthState());
                task.persistStateToClusterState(newState, ActionListener.wrap(rr -> logger.debug("[{}] marked as retrying in TransformState.", (Object)task.getTransformId()), ee -> logger.atWarn().withThrowable((Throwable)ee).log("[{}] failed to persist state.", (Object)task.getTransformId())));
            }
        }, e -> TransformPersistentTasksExecutor.markAsFailed(task, e, "Failed to initiate retries for Transform."));
    }

    private void startTask(TransformTask buildTask, ClientTransformIndexerBuilder indexerBuilder, AuthorizationState authState, Long previousCheckpoint, ActionListener<StartTransformAction.Response> listener) {
        this.threadPool.generic().execute(() -> {
            buildTask.initializeIndexer(indexerBuilder);
            buildTask.setAuthState(authState);
            buildTask.setNumFailureRetries(this.numFailureRetries).start(previousCheckpoint, listener);
        });
    }

    private void setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> persistentTask, Map<String, String> headers) {
        return new TransformTask(id, type, action, parentTaskId, (TransformTaskParams)persistentTask.getParams(), (TransformState)persistentTask.getState(), this.transformServices.getScheduler(), this.auditor, this.threadPool, headers, this.transformServices.getTransformNode());
    }
}

