/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

public class TransformContext {
    private final AtomicReference<TransformTaskState> taskState;
    private final AtomicReference<String> stateReason;
    private volatile Instant stateFailureTime;
    private final Listener taskListener;
    private volatile int numFailureRetries = 10;
    private final AtomicInteger failureCount;
    private final AtomicReference<Throwable> lastFailure = new AtomicReference();
    private volatile Instant lastFailureStartTime;
    private final AtomicInteger statePersistenceFailureCount = new AtomicInteger();
    private final AtomicReference<Throwable> lastStatePersistenceFailure = new AtomicReference();
    private volatile Instant lastStatePersistenceFailureStartTime;
    private final AtomicInteger startUpFailureCount = new AtomicInteger();
    private final AtomicReference<Throwable> lastStartUpFailure = new AtomicReference();
    private volatile Instant startUpFailureTime;
    private volatile Instant changesLastDetectedAt;
    private volatile Instant lastSearchTime;
    private volatile boolean shouldStopAtCheckpoint = false;
    private volatile AuthorizationState authState;
    private volatile int pageSize = 0;
    private final AtomicLong currentCheckpoint;
    private final Instant from;

    public TransformContext(TransformTaskState taskState, String stateReason, long currentCheckpoint, Listener taskListener) {
        this(taskState, stateReason, currentCheckpoint, null, taskListener);
    }

    public TransformContext(TransformTaskState taskState, String stateReason, long currentCheckpoint, Instant from, Listener taskListener) {
        this.taskState = new AtomicReference<TransformTaskState>(taskState);
        this.stateReason = new AtomicReference<String>(stateReason);
        this.currentCheckpoint = new AtomicLong(currentCheckpoint);
        this.from = from;
        this.taskListener = taskListener;
        this.failureCount = new AtomicInteger(0);
    }

    TransformTaskState getTaskState() {
        return this.taskState.get();
    }

    boolean setTaskState(TransformTaskState oldState, TransformTaskState newState) {
        return this.taskState.compareAndSet(oldState, newState);
    }

    void resetTaskState() {
        this.taskState.set(TransformTaskState.STARTED);
        this.stateReason.set(null);
    }

    void setTaskStateToFailed(String reason) {
        this.taskState.set(TransformTaskState.FAILED);
        this.stateReason.set(reason);
        this.stateFailureTime = Instant.now();
    }

    void resetReasonAndFailureCounter() {
        this.stateReason.set(null);
        this.failureCount.set(0);
        this.lastFailure.set(null);
        this.stateFailureTime = null;
        this.lastFailureStartTime = null;
        this.taskListener.failureCountChanged();
    }

    String getStateReason() {
        return this.stateReason.get();
    }

    Instant getStateFailureTime() {
        return this.stateFailureTime;
    }

    void setCheckpoint(long newValue) {
        this.currentCheckpoint.set(newValue);
    }

    long getCheckpoint() {
        return this.currentCheckpoint.get();
    }

    Instant from() {
        return this.from;
    }

    long incrementAndGetCheckpoint() {
        return this.currentCheckpoint.incrementAndGet();
    }

    void setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
    }

    int getNumFailureRetries() {
        return this.numFailureRetries;
    }

    int getFailureCount() {
        return this.failureCount.get();
    }

    int incrementAndGetFailureCount(Throwable failure) {
        int newFailureCount = this.failureCount.incrementAndGet();
        this.lastFailure.set(failure);
        if (newFailureCount == 1) {
            this.lastFailureStartTime = Instant.now();
        }
        this.taskListener.failureCountChanged();
        return newFailureCount;
    }

    Throwable getLastFailure() {
        return this.lastFailure.get();
    }

    Instant getLastFailureStartTime() {
        return this.lastFailureStartTime;
    }

    void setChangesLastDetectedAt(Instant time) {
        this.changesLastDetectedAt = time;
    }

    Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    void setLastSearchTime(Instant time) {
        this.lastSearchTime = time;
    }

    Instant getLastSearchTime() {
        return this.lastSearchTime;
    }

    public boolean shouldStopAtCheckpoint() {
        return this.shouldStopAtCheckpoint;
    }

    public void setShouldStopAtCheckpoint(boolean shouldStopAtCheckpoint) {
        this.shouldStopAtCheckpoint = shouldStopAtCheckpoint;
    }

    public AuthorizationState getAuthState() {
        return this.authState;
    }

    public void setAuthState(AuthorizationState authState) {
        this.authState = authState;
    }

    int getPageSize() {
        return this.pageSize;
    }

    void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    void resetStatePersistenceFailureCount() {
        this.statePersistenceFailureCount.set(0);
        this.lastStatePersistenceFailure.set(null);
        this.lastStatePersistenceFailureStartTime = null;
    }

    int getStatePersistenceFailureCount() {
        return this.statePersistenceFailureCount.get();
    }

    Throwable getLastStatePersistenceFailure() {
        return this.lastStatePersistenceFailure.get();
    }

    int incrementAndGetStatePersistenceFailureCount(Throwable failure) {
        this.lastStatePersistenceFailure.set(failure);
        int newFailureCount = this.statePersistenceFailureCount.incrementAndGet();
        if (newFailureCount == 1) {
            this.lastStatePersistenceFailureStartTime = Instant.now();
        }
        return newFailureCount;
    }

    Instant getLastStatePersistenceFailureStartTime() {
        return this.lastStatePersistenceFailureStartTime;
    }

    void resetStartUpFailureCount() {
        this.startUpFailureCount.set(0);
        this.lastStartUpFailure.set(null);
        this.startUpFailureTime = null;
    }

    int getStartUpFailureCount() {
        return this.startUpFailureCount.get();
    }

    Throwable getStartUpFailure() {
        return this.lastStartUpFailure.get();
    }

    int incrementAndGetStartUpFailureCount(Throwable failure) {
        this.lastStartUpFailure.set(failure);
        int newFailureCount = this.startUpFailureCount.incrementAndGet();
        if (newFailureCount == 1) {
            this.startUpFailureTime = Instant.now();
        }
        return newFailureCount;
    }

    Instant getStartUpFailureTime() {
        return this.startUpFailureTime;
    }

    boolean doesNotHaveFailures() {
        return this.getFailureCount() == 0 && this.getStatePersistenceFailureCount() == 0 && this.getStartUpFailureCount() == 0;
    }

    void shutdown() {
        this.taskListener.shutdown();
    }

    void markAsFailed(Throwable exception, String failureMessage) {
        this.taskListener.fail(exception, failureMessage, (ActionListener<Void>)ActionListener.wrap(r -> this.failureCount.set(0), e -> {}));
    }

    public static interface Listener {
        public void shutdown();

        public void failureCountChanged();

        public void fail(Throwable var1, String var2, ActionListener<Void> var3);
    }
}

