/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointAction;

interface CheckpointClient {
    public void getIndex(GetIndexRequest var1, ActionListener<GetIndexResponse> var2);

    public void getIndicesStats(IndicesStatsRequest var1, ActionListener<IndicesStatsResponse> var2);

    public void getCheckpoint(GetCheckpointAction.Request var1, ActionListener<GetCheckpointAction.Response> var2);

    public static CheckpointClient local(final ElasticsearchClient client) {
        return new CheckpointClient(){

            @Override
            public void getIndex(GetIndexRequest request, ActionListener<GetIndexResponse> listener) {
                client.execute((ActionType)GetIndexAction.INSTANCE, (ActionRequest)request, listener);
            }

            @Override
            public void getIndicesStats(IndicesStatsRequest request, ActionListener<IndicesStatsResponse> listener) {
                client.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)request, listener);
            }

            @Override
            public void getCheckpoint(GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener) {
                client.execute((ActionType)GetCheckpointAction.INSTANCE, (ActionRequest)request, listener);
            }
        };
    }

    public static CheckpointClient remote(final RemoteClusterClient client) {
        return new CheckpointClient(){

            @Override
            public void getIndex(GetIndexRequest request, ActionListener<GetIndexResponse> listener) {
                client.execute(GetIndexAction.REMOTE_TYPE, (ActionRequest)request, listener);
            }

            @Override
            public void getIndicesStats(IndicesStatsRequest request, ActionListener<IndicesStatsResponse> listener) {
                client.execute(IndicesStatsAction.REMOTE_TYPE, (ActionRequest)request, listener);
            }

            @Override
            public void getCheckpoint(GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener) {
                client.execute(GetCheckpointAction.REMOTE_TYPE, (ActionRequest)request, listener);
            }
        };
    }
}

