/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportGetWatchAction
extends WatcherTransportAction<GetWatchRequest, GetWatchResponse> {
    private final WatchParser parser;
    private final Clock clock;
    private final Client client;

    @Inject
    public TransportGetWatchAction(TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, WatchParser parser, ClockHolder clockHolder, Client client) {
        super("cluster:monitor/xpack/watcher/watch/get", transportService, actionFilters, licenseState, GetWatchRequest::new);
        this.parser = parser;
        this.clock = clockHolder.clock;
        this.client = client;
    }

    @Override
    protected void doExecute(GetWatchRequest request, ActionListener<GetWatchResponse> listener) {
        GetRequest getRequest = new GetRequest(".watches", request.getId()).preference(Preference.LOCAL.type()).realtime(true);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (Object)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
            if (getResponse.isExists()) {
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
                    Watch watch = this.parser.parseWithSecrets(request.getId(), true, getResponse.getSourceAsBytesRef(), now, XContentType.JSON, getResponse.getSeqNo(), getResponse.getPrimaryTerm());
                    watch.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).includeStatus(false).build());
                    watch.status().version(getResponse.getVersion());
                    listener.onResponse((Object)new GetWatchResponse(watch.id(), getResponse.getVersion(), watch.getSourceSeqNo(), watch.getSourcePrimaryTerm(), watch.status(), new XContentSource(BytesReference.bytes((XContentBuilder)builder), XContentType.JSON)));
                }
            } else {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
            } else {
                listener.onFailure(e);
            }
        }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }
}

