/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.watcher.WatcherField;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.condition.ConditionRegistry;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.core.watcher.transport.actions.QueryWatchesAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.GetWatcherSettingsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.UpdateWatcherSettingsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.EncryptSensitiveDataBootstrapCheck;
import org.elasticsearch.xpack.watcher.WatcherIndexingListener;
import org.elasticsearch.xpack.watcher.WatcherInfoTransportAction;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.WatcherUsageTransportAction;
import org.elasticsearch.xpack.watcher.actions.email.EmailActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.IndexActionFactory;
import org.elasticsearch.xpack.watcher.actions.jira.JiraActionFactory;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingActionFactory;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyActionFactory;
import org.elasticsearch.xpack.watcher.actions.slack.SlackActionFactory;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookActionFactory;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpSettings;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.condition.ArrayCompareCondition;
import org.elasticsearch.xpack.watcher.condition.CompareCondition;
import org.elasticsearch.xpack.watcher.condition.InternalAlwaysCondition;
import org.elasticsearch.xpack.watcher.condition.NeverCondition;
import org.elasticsearch.xpack.watcher.condition.ScriptCondition;
import org.elasticsearch.xpack.watcher.condition.WatcherConditionScript;
import org.elasticsearch.xpack.watcher.execution.AsyncTriggerEventConsumer;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.InternalWatchExecutor;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.chain.ChainInputFactory;
import org.elasticsearch.xpack.watcher.input.http.HttpInputFactory;
import org.elasticsearch.xpack.watcher.input.none.NoneInputFactory;
import org.elasticsearch.xpack.watcher.input.search.SearchInputFactory;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInputFactory;
import org.elasticsearch.xpack.watcher.input.transform.TransformInputFactory;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.WebhookService;
import org.elasticsearch.xpack.watcher.notification.email.Account;
import org.elasticsearch.xpack.watcher.notification.email.EmailService;
import org.elasticsearch.xpack.watcher.notification.email.HtmlSanitizer;
import org.elasticsearch.xpack.watcher.notification.email.attachment.DataAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentsParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.HttpEmailAttachementParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.ReportingAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.support.BodyPartSource;
import org.elasticsearch.xpack.watcher.notification.jira.JiraService;
import org.elasticsearch.xpack.watcher.notification.pagerduty.PagerDutyService;
import org.elasticsearch.xpack.watcher.notification.slack.SlackService;
import org.elasticsearch.xpack.watcher.rest.action.RestAckWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestActivateWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestDeleteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestExecuteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestGetWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestGetWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.rest.action.RestPutWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestQueryWatchesAction;
import org.elasticsearch.xpack.watcher.rest.action.RestUpdateWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatchServiceAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatcherStatsAction;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransformFactory;
import org.elasticsearch.xpack.watcher.transform.script.WatcherTransformScript;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransformFactory;
import org.elasticsearch.xpack.watcher.transport.actions.TransportAckWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportActivateWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportDeleteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportExecuteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportGetWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportGetWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportPutWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportQueryWatchesAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportUpdateWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportWatcherServiceAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportWatcherStatsAction;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.DailySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.HourlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.IntervalSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.MonthlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.xpack.watcher.trigger.schedule.WeeklySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.YearlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.engine.TickerScheduleTriggerEngine;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class Watcher
extends Plugin
implements SystemIndexPlugin,
ScriptPlugin,
ReloadablePlugin {
    @Deprecated
    public static final Setting<String> INDEX_WATCHER_TEMPLATE_VERSION_SETTING = new Setting("index.xpack.watcher.template.version", "", Function.identity(), new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<Boolean> ENCRYPT_SENSITIVE_DATA_SETTING = Setting.boolSetting((String)"xpack.watcher.encrypt_sensitive_data", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> MAX_STOP_TIMEOUT_SETTING = Setting.timeSetting((String)"xpack.watcher.stop.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> USE_ILM_INDEX_MANAGEMENT = Setting.boolSetting((String)"xpack.watcher.use_ilm_index_management", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> SETTING_BULK_ACTIONS = Setting.intSetting((String)"xpack.watcher.bulk.actions", (int)1, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    @Deprecated(forRemoval=true)
    private static final Setting<Integer> SETTING_BULK_CONCURRENT_REQUESTS = Setting.intSetting((String)"xpack.watcher.bulk.concurrent_requests", (int)0, (int)0, (int)20, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private static final Setting<TimeValue> SETTING_BULK_FLUSH_INTERVAL = Setting.timeSetting((String)"xpack.watcher.bulk.flush_interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<ByteSizeValue> SETTING_BULK_SIZE = Setting.byteSizeSetting((String)"xpack.watcher.bulk.size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final ScriptContext<TemplateScript.Factory> SCRIPT_TEMPLATE_CONTEXT = new ScriptContext("xpack_template", TemplateScript.Factory.class, 200, TimeValue.timeValueMillis((long)0L), false, true);
    private static final Logger logger = LogManager.getLogger(Watcher.class);
    private static final int WATCHES_INDEX_MAPPINGS_VERSION = 1;
    private static final int TRIGGERED_WATCHES_INDEX_MAPPINGS_VERSION = 1;
    private static final String LEGACY_VERSION_FIELD_VALUE = "8.12.0";
    private WatcherIndexingListener listener;
    private HttpClient httpClient;
    private BulkProcessor2 bulkProcessor;
    protected final Settings settings;
    protected final boolean enabled;
    protected List<NotificationService<?>> reloadableServices = new ArrayList();

    public Watcher(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.WATCHER_ENABLED.get(settings);
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Object> createComponents(Plugin.PluginServices services) {
        CryptoService cryptoService;
        if (!this.enabled) {
            return Collections.emptyList();
        }
        Client client = services.client();
        ClusterService clusterService = services.clusterService();
        ThreadPool threadPool = services.threadPool();
        Environment environment = services.environment();
        ScriptService scriptService = services.scriptService();
        NamedXContentRegistry xContentRegistry = services.xContentRegistry();
        FeatureService featureService = services.featureService();
        Predicate<NodeFeature> clusterSupportsFeature = f -> {
            ClusterState state = clusterService.state();
            return state.clusterRecovered() && featureService.clusterHasFeature(state, f);
        };
        BodyPartSource.init();
        Account.init();
        try {
            cryptoService = (Boolean)ENCRYPT_SENSITIVE_DATA_SETTING.get(this.settings) != false ? new CryptoService(this.settings) : null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        WatcherIndexTemplateRegistry templateRegistry = new WatcherIndexTemplateRegistry(environment.settings(), clusterService, threadPool, client, xContentRegistry);
        templateRegistry.initialize();
        SSLService sslService = this.getSslService();
        this.httpClient = new HttpClient(this.settings, sslService, cryptoService, clusterService);
        EmailService emailService = new EmailService(this.settings, cryptoService, sslService, clusterService.getClusterSettings());
        JiraService jiraService = new JiraService(this.settings, this.httpClient, clusterService.getClusterSettings());
        SlackService slackService = new SlackService(this.settings, this.httpClient, clusterService.getClusterSettings());
        PagerDutyService pagerDutyService = new PagerDutyService(this.settings, this.httpClient, clusterService.getClusterSettings());
        WebhookService webhookService = new WebhookService(this.settings, this.httpClient, clusterService.getClusterSettings());
        this.reloadableServices.add(emailService);
        this.reloadableServices.add(jiraService);
        this.reloadableServices.add(slackService);
        this.reloadableServices.add(pagerDutyService);
        this.reloadableServices.add(webhookService);
        TextTemplateEngine templateEngine = new TextTemplateEngine(scriptService);
        HashMap<String, EmailAttachmentParser<? extends EmailAttachmentParser.EmailAttachment>> emailAttachmentParsers = new HashMap<String, EmailAttachmentParser<? extends EmailAttachmentParser.EmailAttachment>>();
        emailAttachmentParsers.put("http", new HttpEmailAttachementParser(webhookService, templateEngine));
        emailAttachmentParsers.put("data", new DataAttachmentParser());
        emailAttachmentParsers.put("reporting", new ReportingAttachmentParser(this.settings, webhookService, templateEngine, clusterService.getClusterSettings()));
        EmailAttachmentsParser emailAttachmentsParser = new EmailAttachmentsParser(emailAttachmentParsers);
        ConditionRegistry conditionRegistry = new ConditionRegistry(Map.of("always", (c, id, p) -> InternalAlwaysCondition.parse(id, p), "never", (c, id, p) -> NeverCondition.parse(id, p), "array_compare", ArrayCompareCondition::parse, "compare", CompareCondition::parse, "script", (c, id, p) -> ScriptCondition.parse(scriptService, id, p)), this.getClock());
        TransformRegistry transformRegistry = new TransformRegistry(Map.of("script", new ScriptTransformFactory(scriptService), "search", new SearchTransformFactory(this.settings, client, xContentRegistry, clusterSupportsFeature, scriptService)));
        HashMap<String, ActionFactory> actionFactoryMap = new HashMap<String, ActionFactory>();
        actionFactoryMap.put("email", new EmailActionFactory(this.settings, emailService, templateEngine, emailAttachmentsParser));
        actionFactoryMap.put("webhook", new WebhookActionFactory(webhookService, templateEngine));
        actionFactoryMap.put("index", new IndexActionFactory(this.settings, client));
        actionFactoryMap.put("logging", new LoggingActionFactory(templateEngine));
        actionFactoryMap.put("jira", new JiraActionFactory(templateEngine, jiraService));
        actionFactoryMap.put("slack", new SlackActionFactory(templateEngine, slackService));
        actionFactoryMap.put("pagerduty", new PagerDutyActionFactory(templateEngine, pagerDutyService));
        ActionRegistry registry = new ActionRegistry(actionFactoryMap, conditionRegistry, transformRegistry, this.getClock(), this.getLicenseState());
        HashMap inputFactories = new HashMap();
        inputFactories.put("search", new SearchInputFactory(this.settings, client, xContentRegistry, clusterSupportsFeature, scriptService));
        inputFactories.put("simple", new SimpleInputFactory());
        inputFactories.put("http", new HttpInputFactory(this.settings, this.httpClient, templateEngine));
        inputFactories.put("none", new NoneInputFactory());
        inputFactories.put("transform", new TransformInputFactory(transformRegistry));
        InputRegistry inputRegistry = new InputRegistry(inputFactories);
        inputFactories.put("chain", new ChainInputFactory(inputRegistry));
        this.bulkProcessor = BulkProcessor2.builder((arg_0, arg_1) -> ((OriginSettingClient)new OriginSettingClient(client, "watcher")).bulk(arg_0, arg_1), (BulkProcessor2.Listener)new BulkProcessor2.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    Map<String, String> overwrittenIds;
                    String failure;
                    Map<String, String> triggeredFailures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).filter(r -> r.getIndex().startsWith(".triggered_watches")).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage));
                    Map<String, String> historyFailures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).filter(r -> r.getIndex().startsWith(".ds-.watcher-history-16")).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage));
                    if (!triggeredFailures.isEmpty()) {
                        failure = String.join((CharSequence)", ", triggeredFailures.values());
                        logger.error("triggered watches could not be deleted {}, failure [{}]", triggeredFailures.keySet(), (Object)Strings.substring((String)failure, (int)0, (int)2000));
                    }
                    if (!historyFailures.isEmpty()) {
                        failure = String.join((CharSequence)", ", historyFailures.values());
                        logger.error("watch history could not be written {}, failure [{}]", historyFailures.keySet(), (Object)Strings.substring((String)failure, (int)0, (int)2000));
                    }
                    if (!(overwrittenIds = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).filter(r -> r.getIndex().startsWith(".ds-.watcher-history-16")).filter(r -> r.getVersion() > 1L).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage))).isEmpty()) {
                        String failure2 = String.join((CharSequence)", ", overwrittenIds.values());
                        logger.info("overwrote watch history entries {}, possible second execution of a triggered watch, failure [{}]", overwrittenIds.keySet(), (Object)Strings.substring((String)failure2, (int)0, (int)2000));
                    }
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Exception failure) {
                logger.error("error executing bulk", (Throwable)failure);
            }
        }, (ThreadPool)client.threadPool()).setFlushInterval((TimeValue)SETTING_BULK_FLUSH_INTERVAL.get(this.settings)).setBulkActions(((Integer)SETTING_BULK_ACTIONS.get(this.settings)).intValue()).setBulkSize((ByteSizeValue)SETTING_BULK_SIZE.get(this.settings)).build();
        HistoryStore historyStore = new HistoryStore(this.bulkProcessor);
        HashSet<Schedule.Parser<? extends Schedule>> scheduleParsers = new HashSet<Schedule.Parser<? extends Schedule>>();
        scheduleParsers.add(new CronSchedule.Parser());
        scheduleParsers.add(new DailySchedule.Parser());
        scheduleParsers.add(new HourlySchedule.Parser());
        scheduleParsers.add(new IntervalSchedule.Parser());
        scheduleParsers.add(new MonthlySchedule.Parser());
        scheduleParsers.add(new WeeklySchedule.Parser());
        scheduleParsers.add(new YearlySchedule.Parser());
        ScheduleRegistry scheduleRegistry = new ScheduleRegistry(scheduleParsers);
        ManualTriggerEngine manualTriggerEngine = new ManualTriggerEngine();
        TriggerEngine<?, ?> configuredTriggerEngine = this.getTriggerEngine(this.getClock(), scheduleRegistry);
        HashSet triggerEngines = new HashSet();
        triggerEngines.add(manualTriggerEngine);
        triggerEngines.add(configuredTriggerEngine);
        TriggerService triggerService = new TriggerService(triggerEngines);
        TriggeredWatch.Parser triggeredWatchParser = new TriggeredWatch.Parser(triggerService);
        TriggeredWatchStore triggeredWatchStore = new TriggeredWatchStore(this.settings, client, triggeredWatchParser, this.bulkProcessor);
        WatcherSearchTemplateService watcherSearchTemplateService = new WatcherSearchTemplateService(scriptService, xContentRegistry, clusterSupportsFeature);
        WatchExecutor watchExecutor = this.getWatchExecutor(threadPool);
        WatchParser watchParser = new WatchParser(triggerService, registry, inputRegistry, cryptoService, this.getClock());
        ExecutionService executionService = new ExecutionService(this.settings, historyStore, triggeredWatchStore, watchExecutor, this.getClock(), watchParser, clusterService, client, threadPool.generic());
        Consumer<Iterable<TriggerEvent>> triggerEngineListener = this.getTriggerEngineListener(executionService);
        triggerService.register(triggerEngineListener);
        WatcherService watcherService = new WatcherService(this.settings, triggerService, triggeredWatchStore, executionService, watchParser, client);
        WatcherLifeCycleService watcherLifeCycleService = new WatcherLifeCycleService(clusterService, watcherService);
        this.listener = new WatcherIndexingListener(watchParser, this.getClock(), triggerService, watcherLifeCycleService.getState());
        clusterService.addListener((ClusterStateListener)this.listener);
        logger.info("Watcher initialized components at {}", (Object)WatcherDateTimeUtils.dateTimeFormatter.formatMillis(this.getClock().millis()));
        return Arrays.asList(new ClockHolder(this.getClock()), registry, inputRegistry, historyStore, triggerService, triggeredWatchParser, watcherLifeCycleService, executionService, triggerEngineListener, watcherService, watchParser, configuredTriggerEngine, triggeredWatchStore, watcherSearchTemplateService, slackService, pagerDutyService);
    }

    protected TriggerEngine<?, ?> getTriggerEngine(Clock clock, ScheduleRegistry scheduleRegistry) {
        return new TickerScheduleTriggerEngine(this.settings, scheduleRegistry, clock);
    }

    protected WatchExecutor getWatchExecutor(ThreadPool threadPool) {
        return new InternalWatchExecutor(threadPool);
    }

    protected Consumer<Iterable<TriggerEvent>> getTriggerEngineListener(ExecutionService executionService) {
        return new AsyncTriggerEventConsumer(executionService);
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(INDEX_WATCHER_TEMPLATE_VERSION_SETTING);
        settings.add(MAX_STOP_TIMEOUT_SETTING);
        settings.add(ExecutionService.DEFAULT_THROTTLE_PERIOD_SETTING);
        settings.add(TickerScheduleTriggerEngine.TICKER_INTERVAL_SETTING);
        settings.add(Setting.intSetting((String)"xpack.watcher.execution.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.intSetting((String)"xpack.watcher.watch.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(ENCRYPT_SENSITIVE_DATA_SETTING);
        settings.add(WatcherField.ENCRYPTION_KEY_SETTING);
        settings.add(USE_ILM_INDEX_MANAGEMENT);
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.bulk.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.actions.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.actions.bulk.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.index.rest.direct_access", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.input.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.transform.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.execution.scroll.timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(SETTING_BULK_ACTIONS);
        settings.add(SETTING_BULK_CONCURRENT_REQUESTS);
        settings.add(SETTING_BULK_FLUSH_INTERVAL);
        settings.add(SETTING_BULK_SIZE);
        settings.addAll(SlackService.getSettings());
        settings.addAll(EmailService.getSettings());
        settings.addAll(HtmlSanitizer.getSettings());
        settings.addAll(JiraService.getSettings());
        settings.addAll(PagerDutyService.getSettings());
        settings.addAll(ReportingAttachmentParser.getSettings());
        settings.addAll(WebhookService.getSettings());
        settings.addAll(HttpSettings.getSettings());
        CryptoService.addSettings(settings);
        return settings;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled) {
            FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "watcher", Watcher.getWatcherThreadPoolSize(settings), 1000, "xpack.watcher.thread_pool", EsExecutors.TaskTrackingConfig.DO_NOT_TRACK);
            return Collections.singletonList(builder);
        }
        return Collections.emptyList();
    }

    static int getWatcherThreadPoolSize(Settings settings) {
        return Watcher.getWatcherThreadPoolSize(DiscoveryNode.canContainData((Settings)settings), EsExecutors.allocatedProcessors((Settings)settings));
    }

    static int getWatcherThreadPoolSize(boolean isDataNode, int allocatedProcessors) {
        if (isDataNode) {
            long size = Math.max(Math.min(5 * allocatedProcessors, 50), allocatedProcessors);
            return Math.toIntExact(size);
        }
        return 1;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler(XPackUsageFeatureAction.WATCHER, WatcherUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler(XPackInfoFeatureAction.WATCHER, WatcherInfoTransportAction.class);
        if (!this.enabled) {
            return Arrays.asList(usageAction, infoAction);
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutWatchAction.INSTANCE, TransportPutWatchAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteWatchAction.INSTANCE, TransportDeleteWatchAction.class), new ActionPlugin.ActionHandler((ActionType)GetWatchAction.INSTANCE, TransportGetWatchAction.class), new ActionPlugin.ActionHandler((ActionType)WatcherStatsAction.INSTANCE, TransportWatcherStatsAction.class), new ActionPlugin.ActionHandler((ActionType)AckWatchAction.INSTANCE, TransportAckWatchAction.class), new ActionPlugin.ActionHandler((ActionType)ActivateWatchAction.INSTANCE, TransportActivateWatchAction.class), new ActionPlugin.ActionHandler((ActionType)WatcherServiceAction.INSTANCE, TransportWatcherServiceAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteWatchAction.INSTANCE, TransportExecuteWatchAction.class), new ActionPlugin.ActionHandler((ActionType)QueryWatchesAction.INSTANCE, TransportQueryWatchesAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateWatcherSettingsAction.INSTANCE, TransportUpdateWatcherSettingsAction.class), new ActionPlugin.ActionHandler((ActionType)GetWatcherSettingsAction.INSTANCE, TransportGetWatcherSettingsAction.class), usageAction, infoAction);
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutWatchAction(), new RestDeleteWatchAction(), new RestWatcherStatsAction(), new RestGetWatchAction(), new RestWatchServiceAction(), new RestWatchServiceAction.StopRestHandler(), new RestAckWatchAction(), new RestActivateWatchAction(), new RestActivateWatchAction.DeactivateRestHandler(), new RestExecuteWatchAction(), new RestQueryWatchesAction(), new RestUpdateWatcherSettingsAction(), new RestGetWatcherSettingsAction()});
    }

    public void onIndexModule(IndexModule module) {
        if (!this.enabled) {
            return;
        }
        assert (this.listener != null);
        module.addIndexOperationListener((IndexingOperationListener)this.listener);
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return map -> {
            map.keySet().removeIf(name -> name.startsWith("watch_history_"));
            map.remove(".watches");
            map.remove(".triggered_watches");
            map.remove(".watch-history-9");
            return map;
        };
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return Collections.singletonList(new EncryptSensitiveDataBootstrapCheck());
    }

    public List<ScriptContext<?>> getContexts() {
        return Arrays.asList(WatcherTransformScript.CONTEXT, WatcherConditionScript.CONTEXT, SCRIPT_TEMPLATE_CONTEXT);
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.httpClient);
        try {
            if (this.enabled && !this.bulkProcessor.awaitClose(10L, TimeUnit.SECONDS)) {
                logger.warn("failed to properly close watcher bulk processor");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void reload(Settings settings) {
        if (!this.enabled) {
            return;
        }
        this.reloadableServices.forEach(s -> s.reload(settings));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(SystemIndexDescriptor.builder().setIndexPattern(".watches*").setPrimaryIndex(".watches").setDescription("Contains Watch definitions").setMappings(Watcher.getWatchesIndexMappings()).setSettings(Watcher.getWatchesIndexSettings()).setVersionMetaKey("version").setOrigin("watcher").setIndexFormat(6).build(), SystemIndexDescriptor.builder().setIndexPattern(".triggered_watches*").setPrimaryIndex(".triggered_watches").setDescription("Used to track current and queued Watch execution").setMappings(Watcher.getTriggeredWatchesIndexMappings()).setSettings(Watcher.getTriggeredWatchesIndexSettings()).setVersionMetaKey("version").setOrigin("watcher").setIndexFormat(6).build());
    }

    public String getFeatureName() {
        return "watcher";
    }

    public void prepareForIndicesMigration(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
        OriginSettingClient originClient = new OriginSettingClient(client, "watcher");
        boolean manuallyStopped = Optional.ofNullable((WatcherMetadata)clusterService.state().metadata().custom("watcher")).map(WatcherMetadata::manuallyStopped).orElse(false);
        if (!manuallyStopped) {
            WatcherServiceRequest serviceRequest = new WatcherServiceRequest();
            serviceRequest.stop();
            originClient.execute((ActionType)WatcherServiceAction.INSTANCE, (ActionRequest)serviceRequest, ActionListener.wrap(response -> listener.onResponse(Collections.singletonMap("manually_stopped", manuallyStopped)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse(Collections.singletonMap("manually_stopped", manuallyStopped));
        }
    }

    public void indicesMigrationComplete(Map<String, Object> preUpgradeMetadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
        OriginSettingClient originClient = new OriginSettingClient(client, "watcher");
        boolean manuallyStopped = (Boolean)preUpgradeMetadata.getOrDefault("manually_stopped", false);
        if (!manuallyStopped) {
            WatcherServiceRequest serviceRequest = new WatcherServiceRequest();
            serviceRequest.start();
            originClient.execute((ActionType)WatcherServiceAction.INSTANCE, (ActionRequest)serviceRequest, ActionListener.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)true);
        }
    }

    public String getFeatureDescription() {
        return "Manages Watch definitions and state";
    }

    private static Settings getWatchesIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 6).put("index.priority", 800).build();
    }

    private static XContentBuilder getWatchesIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.field("dynamic", "strict");
            builder.startObject("_meta");
            builder.field("version", LEGACY_VERSION_FIELD_VALUE);
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.startObject("properties");
            builder.startObject("status");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("trigger");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("input");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("condition");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("throttle_period");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("throttle_period_in_millis");
            builder.field("type", "long");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("transform");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("actions");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.field("dynamic", true);
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", true);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .watches index mappings", e);
        }
    }

    private static Settings getTriggeredWatchesIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.refresh_interval", "-1").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 6).put("index.priority", 900).build();
    }

    private static XContentBuilder getTriggeredWatchesIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.field("dynamic", "strict");
            builder.startObject("_meta");
            builder.field("version", LEGACY_VERSION_FIELD_VALUE);
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.startObject("properties");
            builder.startObject("trigger_event");
            builder.field("type", "object");
            builder.field("dynamic", true);
            builder.field("enabled", false);
            builder.startObject("properties");
            builder.startObject("schedule");
            builder.field("type", "object");
            builder.field("dynamic", true);
            builder.startObject("properties");
            builder.startObject("triggered_time");
            builder.field("type", "date");
            builder.endObject();
            builder.startObject("scheduled_time");
            builder.field("type", "date");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("state");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .triggered_watches index mappings", e);
        }
    }
}

