/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;

abstract class MetricFieldProducer
extends AbstractDownsampleFieldProducer {
    private final Metric[] metrics;

    MetricFieldProducer(String name, Metric ... metrics) {
        super(name);
        this.metrics = metrics;
    }

    @Override
    public void reset() {
        for (Metric metric : this.metrics) {
            metric.reset();
        }
        this.isEmpty = true;
    }

    public Metric[] metrics() {
        return this.metrics;
    }

    void collect(Number value) {
        for (Metric metric : this.metrics()) {
            metric.collect(value);
        }
        this.isEmpty = false;
    }

    @Override
    public void collect(FormattedDocValues docValues, int docId) throws IOException {
        if (!docValues.advanceExact(docId)) {
            return;
        }
        int docValuesCount = docValues.docValueCount();
        for (int i = 0; i < docValuesCount; ++i) {
            Number num = (Number)docValues.nextValue();
            this.collect(num);
        }
    }

    static abstract class Metric {
        final String name;

        protected Metric(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        abstract void collect(Number var1);

        abstract Number get();

        abstract void reset();
    }

    static class GaugeMetricFieldProducer
    extends MetricFieldProducer {
        GaugeMetricFieldProducer(String name) {
            this(name, new Min(), new Max(), new Sum(), new ValueCount());
        }

        GaugeMetricFieldProducer(String name, Metric ... metrics) {
            super(name, metrics);
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.startObject(this.name());
                for (Metric metric : this.metrics()) {
                    if (metric.get() == null) continue;
                    builder.field(metric.name(), metric.get());
                }
                builder.endObject();
            }
        }
    }

    static class CounterMetricFieldProducer
    extends MetricFieldProducer {
        CounterMetricFieldProducer(String name) {
            super(name, new LastValue());
        }

        @Override
        public void collect(FormattedDocValues docValues, int docId) throws IOException {
            if (this.isEmpty()) {
                super.collect(docValues, docId);
            }
        }

        public Object value() {
            assert (this.metrics().length == 1) : "Single value producers must have only one metric";
            return this.metrics()[0].get();
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.field(this.name(), this.value());
            }
        }
    }

    static class LastValue
    extends Metric {
        private Number lastValue;

        LastValue() {
            super("last_value");
        }

        @Override
        void collect(Number value) {
            if (this.lastValue == null) {
                this.lastValue = value;
            }
        }

        @Override
        Number get() {
            return this.lastValue;
        }

        @Override
        void reset() {
            this.lastValue = null;
        }
    }

    static class ValueCount
    extends Metric {
        private long count;

        ValueCount() {
            super("value_count");
        }

        @Override
        void collect(Number value) {
            ++this.count;
        }

        @Override
        Number get() {
            return this.count;
        }

        @Override
        void reset() {
            this.count = 0L;
        }
    }

    static class Sum
    extends Metric {
        private final CompensatedSum kahanSummation = new CompensatedSum();

        Sum() {
            super("sum");
        }

        Sum(String name) {
            super(name);
        }

        @Override
        void collect(Number value) {
            this.kahanSummation.add(value.doubleValue());
        }

        @Override
        Number get() {
            return this.kahanSummation.value();
        }

        @Override
        void reset() {
            this.kahanSummation.reset(0.0, 0.0);
        }
    }

    static class Min
    extends Metric {
        private Double min;

        Min() {
            super("min");
        }

        @Override
        void collect(Number value) {
            this.min = this.min != null ? Math.min(value.doubleValue(), this.min) : value.doubleValue();
        }

        @Override
        Number get() {
            return this.min;
        }

        @Override
        void reset() {
            this.min = null;
        }
    }

    static class Max
    extends Metric {
        private Double max;

        Max() {
            super("max");
        }

        @Override
        void collect(Number value) {
            this.max = this.max != null ? Math.max(value.doubleValue(), this.max) : value.doubleValue();
        }

        @Override
        Number get() {
            return this.max;
        }

        @Override
        void reset() {
            this.max = null;
        }
    }
}

