/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.fleet.action.DeleteSecretRequest;
import org.elasticsearch.xpack.fleet.action.DeleteSecretResponse;

public class TransportDeleteSecretAction
extends HandledTransportAction<DeleteSecretRequest, DeleteSecretResponse> {
    private final Client client;

    @Inject
    public TransportDeleteSecretAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/fleet/secrets/delete", transportService, actionFilters, DeleteSecretRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "fleet");
    }

    protected void doExecute(Task task, DeleteSecretRequest request, ActionListener<DeleteSecretResponse> listener) {
        this.client.prepareDelete(".fleet-secrets", request.id()).execute(listener.delegateFailureAndWrap((delegate, deleteResponse) -> {
            if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                delegate.onFailure((Exception)new ResourceNotFoundException("No secret with id [" + request.id() + "]", new Object[0]));
                return;
            }
            delegate.onResponse((Object)new DeleteSecretResponse(deleteResponse.getResult() == DocWriteResponse.Result.DELETED));
        }));
    }
}

