/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;

class ContendedRegisterAnalyzeAction
extends HandledTransportAction<Request, ActionResponse.Empty> {
    private static final Logger logger = LogManager.getLogger(ContendedRegisterAnalyzeAction.class);
    static final String NAME = "cluster:admin/repository/analyze/register";
    private final RepositoriesService repositoriesService;
    private final Executor executor;

    ContendedRegisterAnalyzeAction(TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
        super(NAME, transportService, actionFilters, Request::new, (Executor)transportService.getThreadPool().executor("snapshot"));
        this.repositoriesService = repositoriesService;
        this.executor = transportService.getThreadPool().executor("snapshot");
    }

    protected void doExecute(final Task task, final Request request, ActionListener<ActionResponse.Empty> outerListenerOld) {
        final ActionListener outerListener = ActionListener.assertOnce(outerListenerOld);
        Repository repository = this.repositoriesService.repository(request.getRepositoryName());
        if (!(repository instanceof BlobStoreRepository)) {
            throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is not a blob-store repository");
        }
        if (repository.isReadOnly()) {
            throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is read-only");
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        BlobPath path = blobStoreRepository.basePath().add(request.getContainerPath());
        final BlobContainer blobContainer = blobStoreRepository.blobStore().blobContainer(path);
        logger.trace("handling [{}]", (Object)request);
        assert (task instanceof CancellableTask);
        final String registerName = request.getRegisterName();
        ActionListener<OptionalBytesReference> initialValueListener = new ActionListener<OptionalBytesReference>(){

            public void onResponse(OptionalBytesReference maybeInitialBytes) {
                long initialValue = maybeInitialBytes.isPresent() ? ContendedRegisterAnalyzeAction.longFromBytes(maybeInitialBytes.bytesReference()) : 0L;
                ActionListener.run((ActionListener)outerListener.map(ignored -> ActionResponse.Empty.INSTANCE), l -> {
                    if (initialValue < 0L || initialValue >= (long)request.getRequestCount()) {
                        throw new IllegalStateException("register holds unexpected value [" + initialValue + "]");
                    }
                    class Execution
                    extends ActionRunnable<Void> {
                        private long currentValue;
                        private final ActionListener<OptionalBytesReference> witnessListener;
                        final /* synthetic */ ActionListener val$l;
                        final /* synthetic */ Task val$task;
                        final /* synthetic */ BlobContainer val$blobContainer;
                        final /* synthetic */ String val$registerName;
                        final /* synthetic */ Request val$request;

                        Execution(long currentValue) {
                            this.val$l = actionListener;
                            this.val$task = task;
                            this.val$blobContainer = blobContainer;
                            this.val$registerName = string;
                            this.val$request = request;
                            super(actionListener);
                            this.currentValue = currentValue;
                            this.witnessListener = this.listener.delegateFailure(this::handleWitness);
                        }

                        protected void doRun() {
                            if (!((CancellableTask)this.val$task).notifyIfCancelled(this.listener)) {
                                this.val$blobContainer.compareAndExchangeRegister(OperationPurpose.REPOSITORY_ANALYSIS, this.val$registerName, ContendedRegisterAnalyzeAction.bytesFromLong(this.currentValue), ContendedRegisterAnalyzeAction.bytesFromLong(this.currentValue + 1L), this.witnessListener);
                            }
                        }

                        private void handleWitness(ActionListener<Void> delegate, OptionalBytesReference witnessOrEmpty) {
                            if (!witnessOrEmpty.isPresent()) {
                                ContendedRegisterAnalyzeAction.this.executor.execute((Runnable)((Object)this));
                                return;
                            }
                            long witness = ContendedRegisterAnalyzeAction.longFromBytes(witnessOrEmpty.bytesReference());
                            if (witness == this.currentValue) {
                                delegate.onResponse(null);
                            } else if (witness < this.currentValue || witness >= (long)this.val$request.getRequestCount()) {
                                delegate.onFailure((Exception)new IllegalStateException("register holds unexpected value [" + witness + "]"));
                            } else {
                                this.currentValue = witness;
                                ContendedRegisterAnalyzeAction.this.executor.execute((Runnable)((Object)this));
                            }
                        }
                    }
                    new Execution(initialValue).run();
                });
            }

            public void onFailure(Exception e) {
                if (e instanceof UnsupportedOperationException) {
                    outerListener.onResponse((Object)ActionResponse.Empty.INSTANCE);
                } else {
                    outerListener.onFailure(e);
                }
            }
        };
        if (request.getInitialRead() > request.getRequestCount()) {
            blobContainer.getRegister(OperationPurpose.REPOSITORY_ANALYSIS, registerName, (ActionListener)initialValueListener);
        } else {
            blobContainer.compareAndExchangeRegister(OperationPurpose.REPOSITORY_ANALYSIS, registerName, ContendedRegisterAnalyzeAction.bytesFromLong(request.getInitialRead()), ContendedRegisterAnalyzeAction.bytesFromLong(request.getInitialRead() == request.getRequestCount() ? (long)(request.getRequestCount() + 1) : (long)request.getInitialRead()), (ActionListener)initialValueListener);
        }
    }

    static long longFromBytes(BytesReference bytesReference) {
        if (bytesReference.length() == 0) {
            return 0L;
        }
        if (bytesReference.length() == 8) {
            long l;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            try {
                bytesReference.writeTo((OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                assert (bytes.length == 8);
                l = ByteUtils.readLongBE((byte[])bytes, (int)0);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    assert (false) : "no IO takes place";
                    throw new IllegalStateException("unexpected conversion error", e);
                }
            }
            baos.close();
            return l;
        }
        throw new IllegalArgumentException("cannot read long from BytesReference of length " + bytesReference.length());
    }

    static BytesReference bytesFromLong(long value) {
        if (value == 0L) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[8];
        ByteUtils.writeLongBE((long)value, (byte[])bytes, (int)0);
        return new BytesArray(bytes);
    }

    static class Request
    extends ActionRequest {
        private final String repositoryName;
        private final String containerPath;
        private final String registerName;
        private final int requestCount;
        private final int initialRead;

        Request(String repositoryName, String containerPath, String registerName, int requestCount, int initialRead) {
            this.repositoryName = repositoryName;
            this.containerPath = containerPath;
            this.registerName = registerName;
            this.requestCount = requestCount;
            this.initialRead = initialRead;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0));
            this.repositoryName = in.readString();
            this.containerPath = in.readString();
            this.registerName = in.readString();
            this.requestCount = in.readVInt();
            this.initialRead = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0));
            super.writeTo(out);
            out.writeString(this.repositoryName);
            out.writeString(this.containerPath);
            out.writeString(this.registerName);
            out.writeVInt(this.requestCount);
            out.writeVInt(this.initialRead);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        String getContainerPath() {
            return this.containerPath;
        }

        String getRegisterName() {
            return this.registerName;
        }

        int getRequestCount() {
            return this.requestCount;
        }

        int getInitialRead() {
            return this.initialRead;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return Strings.format((String)"ContendedRegisterAnalyzeAction.Request{repositoryName='%s', containerPath='%s', registerName='%s', requestCount='%d', initialRead='%d'}", (Object[])new Object[]{this.repositoryName, this.containerPath, this.registerName, this.requestCount, this.initialRead});
        }
    }
}

