/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.spatial.CartesianShapeDocValuesQuery;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeFieldMapper;

public class ShapeQueryProcessor {
    public Query shapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, SearchExecutionContext context, boolean hasDocValues) {
        XYGeometry[] luceneGeometries;
        this.validateIsShapeFieldType(fieldName, context);
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before((VersionId)IndexVersions.V_7_5_0)) {
            throw new QueryShardException((QueryRewriteContext)context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        if (geometry == null || geometry.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        try {
            luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
        }
        catch (IllegalArgumentException e) {
            throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        Query query = XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (XYGeometry[])luceneGeometries);
        if (hasDocValues) {
            CartesianShapeDocValuesQuery queryDocValues = new CartesianShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
            query = new IndexOrDocValuesQuery(query, (Query)queryDocValues);
        }
        return query;
    }

    private void validateIsShapeFieldType(String fieldName, SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        if (!(fieldType instanceof ShapeFieldMapper.ShapeFieldType)) {
            throw new QueryShardException((QueryRewriteContext)context, "Expected shape field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }
}

