/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.idp;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderResolver;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderDefaults;
import org.elasticsearch.xpack.idp.saml.sp.WildcardServiceProviderResolver;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.impl.X509KeyManagerX509CredentialAdapter;

public class SamlIdentityProviderBuilder {
    private static final List<String> ALLOWED_NAMEID_FORMATS = List.of("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
    public static final Setting<String> IDP_ENTITY_ID = Setting.simpleString((String)"xpack.idp.entity_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> IDP_SSO_REDIRECT_ENDPOINT = new Setting("xpack.idp.sso_endpoint.redirect", "https:", value -> SamlIdentityProviderBuilder.parseUrl("xpack.idp.sso_endpoint.redirect", value), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> IDP_SSO_POST_ENDPOINT = new Setting("xpack.idp.sso_endpoint.post", "https:", value -> SamlIdentityProviderBuilder.parseUrl("xpack.idp.sso_endpoint.post", value), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> IDP_SLO_REDIRECT_ENDPOINT = new Setting("xpack.idp.slo_endpoint.redirect", "https:", value -> SamlIdentityProviderBuilder.parseUrl("xpack.idp.slo_endpoint.redirect", value), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> IDP_SLO_POST_ENDPOINT = new Setting("xpack.idp.slo_endpoint.post", "https:", value -> SamlIdentityProviderBuilder.parseUrl("xpack.idp.slo_endpoint.post", value), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> IDP_ALLOWED_NAMEID_FORMATS = Setting.listSetting((String)"xpack.idp.allowed_nameid_formats", List.of("urn:oasis:names:tc:SAML:2.0:nameid-format:transient"), Function.identity(), SamlIdentityProviderBuilder::validateNameIDs, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_SIGNING_KEY_ALIAS = Setting.simpleString((String)"xpack.idp.signing.keystore.alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_METADATA_SIGNING_KEY_ALIAS = Setting.simpleString((String)"xpack.idp.metadata.signing.keystore.alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_ORGANIZATION_NAME = Setting.simpleString((String)"xpack.idp.organization.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_ORGANIZATION_DISPLAY_NAME = Setting.simpleString((String)"xpack.idp.organization.display_name", IDP_ORGANIZATION_NAME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> IDP_ORGANIZATION_URL = new Setting("xpack.idp.organization.url", "http:", value -> SamlIdentityProviderBuilder.parseUrl("xpack.idp.organization.url", value), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_CONTACT_GIVEN_NAME = Setting.simpleString((String)"xpack.idp.contact.given_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_CONTACT_SURNAME = Setting.simpleString((String)"xpack.idp.contact.surname", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_CONTACT_EMAIL = Setting.simpleString((String)"xpack.idp.contact.email", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final SamlServiceProviderResolver serviceProviderResolver;
    private final WildcardServiceProviderResolver wildcardServiceResolver;
    private String entityId;
    private Map<String, URL> ssoEndpoints;
    private Map<String, URL> sloEndpoints;
    private Set<String> allowedNameIdFormats;
    private X509Credential signingCredential;
    private X509Credential metadataSigningCredential;
    private SamlIdentityProvider.ContactInfo technicalContact;
    private SamlIdentityProvider.OrganizationInfo organization;
    private ServiceProviderDefaults serviceProviderDefaults;

    SamlIdentityProviderBuilder(SamlServiceProviderResolver serviceProviderResolver, WildcardServiceProviderResolver wildcardResolver) {
        this.serviceProviderResolver = serviceProviderResolver;
        this.wildcardServiceResolver = wildcardResolver;
        this.ssoEndpoints = new HashMap<String, URL>();
        this.sloEndpoints = new HashMap<String, URL>();
    }

    public SamlIdentityProvider build() throws ValidationException {
        ValidationException ex = new ValidationException();
        if (Strings.isNullOrEmpty((String)this.entityId)) {
            ex.addValidationError("IDP Entity ID must be set (was [" + this.entityId + "])");
        }
        if (this.ssoEndpoints == null || !this.ssoEndpoints.containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
            ex.addValidationError("The redirect ([ urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect]) SSO binding is required");
        }
        if (this.signingCredential == null) {
            ex.addValidationError("Signing credential must be specified");
        } else {
            try {
                SamlIdentityProviderBuilder.validateSigningKey(this.signingCredential.getPrivateKey());
            }
            catch (ElasticsearchSecurityException e) {
                ex.addValidationError("Signing credential is invalid - " + e.getMessage());
            }
        }
        if (this.metadataSigningCredential != null) {
            try {
                SamlIdentityProviderBuilder.validateSigningKey(this.metadataSigningCredential.getPrivateKey());
            }
            catch (ElasticsearchSecurityException e) {
                ex.addValidationError("Metadata signing credential is invalid - " + e.getMessage());
            }
        }
        if (this.serviceProviderDefaults == null) {
            ex.addValidationError("Service provider defaults must be specified");
        }
        if (this.allowedNameIdFormats == null || this.allowedNameIdFormats.isEmpty()) {
            ex.addValidationError("At least 1 allowed NameID format must be specified");
        }
        if (!ex.validationErrors().isEmpty()) {
            throw ex;
        }
        return new SamlIdentityProvider(this.entityId, Map.copyOf(this.ssoEndpoints), this.sloEndpoints == null ? Map.of() : Map.copyOf(this.sloEndpoints), Set.copyOf(this.allowedNameIdFormats), this.signingCredential, this.metadataSigningCredential, this.technicalContact, this.organization, this.serviceProviderDefaults, this.serviceProviderResolver, this.wildcardServiceResolver);
    }

    public SamlIdentityProviderBuilder fromSettings(Environment env) {
        Settings settings = env.settings();
        this.entityId = SamlIdentityProviderBuilder.require(settings, IDP_ENTITY_ID);
        this.ssoEndpoints = new HashMap<String, URL>();
        this.sloEndpoints = new HashMap<String, URL>();
        this.ssoEndpoints.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", SamlIdentityProviderBuilder.requiredUrl(settings, IDP_SSO_REDIRECT_ENDPOINT));
        if (IDP_SSO_POST_ENDPOINT.exists(settings)) {
            this.ssoEndpoints.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (URL)IDP_SSO_POST_ENDPOINT.get(settings));
        }
        if (IDP_SLO_POST_ENDPOINT.exists(settings)) {
            this.sloEndpoints.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (URL)IDP_SLO_POST_ENDPOINT.get(settings));
        }
        if (IDP_SLO_REDIRECT_ENDPOINT.exists(settings)) {
            this.sloEndpoints.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (URL)IDP_SLO_REDIRECT_ENDPOINT.get(settings));
        }
        this.allowedNameIdFormats = new HashSet<String>((Collection)IDP_ALLOWED_NAMEID_FORMATS.get(settings));
        this.signingCredential = SamlIdentityProviderBuilder.buildSigningCredential(env, settings, "xpack.idp.signing.");
        this.metadataSigningCredential = SamlIdentityProviderBuilder.buildSigningCredential(env, settings, "xpack.idp.metadata_signing.");
        this.technicalContact = SamlIdentityProviderBuilder.buildContactInfo(settings);
        this.organization = SamlIdentityProviderBuilder.buildOrganization(settings);
        return this;
    }

    public static List<? extends Setting<?>> getSettings() {
        return List.of(IDP_ENTITY_ID, IDP_SLO_REDIRECT_ENDPOINT, IDP_SLO_POST_ENDPOINT, IDP_SSO_REDIRECT_ENDPOINT, IDP_SSO_POST_ENDPOINT, IDP_ALLOWED_NAMEID_FORMATS, IDP_SIGNING_KEY_ALIAS, IDP_METADATA_SIGNING_KEY_ALIAS, IDP_ORGANIZATION_NAME, IDP_ORGANIZATION_DISPLAY_NAME, IDP_ORGANIZATION_URL, IDP_CONTACT_GIVEN_NAME, IDP_CONTACT_SURNAME, IDP_CONTACT_EMAIL);
    }

    public SamlIdentityProviderBuilder serviceProviderDefaults(ServiceProviderDefaults serviceProviderDefaults) {
        this.serviceProviderDefaults = serviceProviderDefaults;
        return this;
    }

    public SamlIdentityProviderBuilder entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public SamlIdentityProviderBuilder singleSignOnEndpoints(Map<String, URL> ssoEndpointsMap) {
        this.ssoEndpoints = ssoEndpointsMap;
        return this;
    }

    public SamlIdentityProviderBuilder singleLogoutEndpoints(Map<String, URL> sloEndpointsMap) {
        this.sloEndpoints = sloEndpointsMap;
        return this;
    }

    public SamlIdentityProviderBuilder singleSignOnEndpoint(String binding, URL endpoint) {
        this.ssoEndpoints.put(binding, endpoint);
        return this;
    }

    public SamlIdentityProviderBuilder singleLogoutEndpoint(String binding, URL endpoint) {
        this.sloEndpoints.put(binding, endpoint);
        return this;
    }

    public SamlIdentityProviderBuilder allowedNameIdFormat(String nameIdFormat) {
        if (this.allowedNameIdFormats == null) {
            this.allowedNameIdFormats = new HashSet<String>();
        }
        this.allowedNameIdFormats.add(nameIdFormat);
        return this;
    }

    public SamlIdentityProviderBuilder signingCredential(X509Credential signingCredential) {
        this.signingCredential = signingCredential;
        return this;
    }

    public SamlIdentityProviderBuilder metadataSigningCredential(X509Credential metadataSigningCredential) {
        this.metadataSigningCredential = metadataSigningCredential;
        return this;
    }

    public SamlIdentityProviderBuilder technicalContact(SamlIdentityProvider.ContactInfo technicalContact) {
        this.technicalContact = technicalContact;
        return this;
    }

    public SamlIdentityProviderBuilder organization(SamlIdentityProvider.OrganizationInfo organization) {
        this.organization = organization;
        return this;
    }

    private static URL parseUrl(String key, String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Not a valid URL", e);
        }
    }

    private static void validateNameIDs(List<String> values) {
        Set invalidFormats = values.stream().distinct().filter(e -> !ALLOWED_NAMEID_FORMATS.contains(e)).collect(Collectors.toSet());
        if (invalidFormats.size() > 0) {
            throw new IllegalArgumentException(invalidFormats + " are not valid NameID formats. Allowed values are " + ALLOWED_NAMEID_FORMATS);
        }
    }

    static String require(Settings settings, Setting<String> setting) {
        if (settings.hasValue(setting.getKey())) {
            return (String)setting.get(settings);
        }
        throw new IllegalArgumentException("The configuration setting [" + setting.getKey() + "] is required");
    }

    static URL requiredUrl(Settings settings, Setting<URL> setting) {
        if (settings.hasValue(setting.getKey())) {
            return (URL)setting.get(settings);
        }
        throw new IllegalArgumentException("The configuration setting [" + setting.getKey() + "] is required");
    }

    static X509Credential buildSigningCredential(Environment environment, Settings settings, String prefix) {
        List<X509Credential> credentials = SamlIdentityProviderBuilder.buildCredentials(environment, settings, prefix, false);
        if (credentials.isEmpty()) {
            return null;
        }
        return credentials.get(0);
    }

    static List<X509Credential> buildCredentials(Environment env, Settings settings, String prefix, boolean allowMultiple) {
        SslKeyConfig keyConfig = CertParsingUtils.createKeyConfig((Settings)settings, (String)prefix, (Environment)env, (boolean)false);
        if (!keyConfig.hasKeyMaterial()) {
            return List.of();
        }
        X509ExtendedKeyManager keyManager = keyConfig.createKeyManager();
        if (keyManager == null) {
            return List.of();
        }
        ArrayList<X509Credential> credentials = new ArrayList<X509Credential>();
        HashSet<String> selectedAliases = new HashSet<String>();
        String configAlias = settings.get(prefix + "keystore.alias");
        if (Strings.isNullOrEmpty((String)configAlias)) {
            String[] ecAliases;
            String[] rsaAliases = keyManager.getServerAliases("RSA", null);
            if (null != rsaAliases) {
                selectedAliases.addAll(Arrays.asList(rsaAliases));
            }
            if (null != (ecAliases = keyManager.getServerAliases("EC", null))) {
                selectedAliases.addAll(Arrays.asList(ecAliases));
            }
            if (selectedAliases.isEmpty()) {
                throw new IllegalArgumentException("The configured keystore for [" + prefix + "keystore] does not contain any RSA or EC key pairs.");
            }
            if (selectedAliases.size() > 1 && !allowMultiple) {
                throw new IllegalArgumentException("The configured keystore for [" + prefix + "keystore] contains multiple private key entries, when one was expected.");
            }
        } else {
            selectedAliases.add(configAlias);
        }
        for (String alias : selectedAliases) {
            try {
                SamlIdentityProviderBuilder.validateSigningKey(keyManager.getPrivateKey(alias));
            }
            catch (ElasticsearchSecurityException e) {
                throw new IllegalArgumentException("The configured credential [" + prefix + "keystore] with alias [" + alias + "] is not a valid signing key - " + e.getMessage());
            }
            credentials.add((X509Credential)new X509KeyManagerX509CredentialAdapter((X509KeyManager)keyManager, alias));
        }
        return credentials;
    }

    private static void validateSigningKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new ElasticsearchSecurityException("There is no private key available for this credential", new Object[0]);
        }
        String keyType = privateKey.getAlgorithm();
        if (!keyType.equals("RSA") && !keyType.equals("EC")) {
            throw new ElasticsearchSecurityException("The private key uses unsupported key algorithm type [" + keyType + "], only RSA and EC are supported", new Object[0]);
        }
    }

    private static SamlIdentityProvider.OrganizationInfo buildOrganization(Settings settings) {
        String url;
        String name = settings.hasValue(IDP_ORGANIZATION_NAME.getKey()) ? (String)IDP_ORGANIZATION_NAME.get(settings) : null;
        String displayName = settings.hasValue(IDP_ORGANIZATION_DISPLAY_NAME.getKey()) ? (String)IDP_ORGANIZATION_DISPLAY_NAME.get(settings) : null;
        String string = url = settings.hasValue(IDP_ORGANIZATION_URL.getKey()) ? ((URL)IDP_ORGANIZATION_URL.get(settings)).toString() : null;
        if (!Stream.of(name, displayName, url).allMatch(Objects::isNull)) {
            return new SamlIdentityProvider.OrganizationInfo(name, displayName, url);
        }
        return null;
    }

    private static SamlIdentityProvider.ContactInfo buildContactInfo(Settings settings) {
        if (settings.hasValue(IDP_CONTACT_EMAIL.getKey())) {
            return new SamlIdentityProvider.ContactInfo(ContactPersonTypeEnumeration.TECHNICAL, (String)IDP_CONTACT_GIVEN_NAME.get(settings), (String)IDP_CONTACT_SURNAME.get(settings), (String)IDP_CONTACT_EMAIL.get(settings));
        }
        return null;
    }
}

