/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.privileges;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.idp.privileges.ApplicationActionsResolver;
import org.elasticsearch.xpack.idp.privileges.ServiceProviderPrivileges;

public class UserPrivilegeResolver {
    private static final Logger logger = LogManager.getLogger(UserPrivilegeResolver.class);
    private final Client client;
    private final SecurityContext securityContext;
    private final ApplicationActionsResolver actionsResolver;

    public UserPrivilegeResolver(Client client, SecurityContext securityContext, ApplicationActionsResolver actionsResolver) {
        this.client = client;
        this.securityContext = securityContext;
        this.actionsResolver = actionsResolver;
    }

    public void resolve(ServiceProviderPrivileges service, ActionListener<UserPrivileges> listener) {
        this.buildResourcePrivilege(service, (ActionListener<RoleDescriptor.ApplicationResourcePrivileges>)listener.delegateFailureAndWrap((delegate, resourcePrivilege) -> {
            String username = this.securityContext.requireUser().principal();
            if (resourcePrivilege == null) {
                delegate.onResponse((Object)UserPrivileges.noAccess(username));
                return;
            }
            HasPrivilegesRequest request = new HasPrivilegesRequest();
            request.username(username);
            request.clusterPrivileges(Strings.EMPTY_ARRAY);
            request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
            request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[]{resourcePrivilege});
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)request, delegate.delegateFailureAndWrap((l, response) -> {
                logger.debug("Checking access for user [{}] to application [{}] resource [{}]", (Object)username, (Object)service.getApplicationName(), (Object)service.getResource());
                UserPrivileges privileges = UserPrivilegeResolver.buildResult(response, service);
                logger.debug("Resolved service privileges [{}]", (Object)privileges);
                l.onResponse((Object)privileges);
            }));
        }));
    }

    private static UserPrivileges buildResult(HasPrivilegesResponse response, ServiceProviderPrivileges service) {
        Set appPrivileges = (Set)response.getApplicationPrivileges().get(service.getApplicationName());
        if (appPrivileges == null || appPrivileges.isEmpty()) {
            return UserPrivileges.noAccess(response.getUsername());
        }
        Set<String> roles = appPrivileges.stream().filter(rp -> rp.getResource().equals(service.getResource())).map(rp -> rp.getPrivileges().entrySet()).flatMap(Collection::stream).filter(Map.Entry::getValue).map(Map.Entry::getKey).map(service.getRoleMapping()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        boolean hasAccess = !roles.isEmpty();
        return new UserPrivileges(response.getUsername(), hasAccess, roles);
    }

    private void buildResourcePrivilege(ServiceProviderPrivileges service, ActionListener<RoleDescriptor.ApplicationResourcePrivileges> listener) {
        GroupedActionListener groupedListener = new GroupedActionListener(2, listener.delegateFailureAndWrap((delegate, actionSets) -> {
            Set actions = actionSets.stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
            if (actions == null || actions.isEmpty()) {
                logger.warn("No application-privilege actions defined for application [{}]", (Object)service.getApplicationName());
                delegate.onResponse(null);
            } else {
                logger.debug("Using actions [{}] for application [{}]", actions, (Object)service.getApplicationName());
                RoleDescriptor.ApplicationResourcePrivileges.Builder builder = RoleDescriptor.ApplicationResourcePrivileges.builder();
                builder.application(service.getApplicationName());
                builder.resources(new String[]{service.getResource()});
                builder.privileges(actions);
                delegate.onResponse((Object)builder.build());
            }
        }));
        GetUserPrivilegesRequest request = (GetUserPrivilegesRequest)new GetUserPrivilegesRequestBuilder((ElasticsearchClient)this.client).username(this.securityContext.getUser().principal()).request();
        this.client.execute((ActionType)GetUserPrivilegesAction.INSTANCE, (ActionRequest)request, groupedListener.map(userPrivileges -> userPrivileges.getApplicationPrivileges().stream().filter(appPriv -> appPriv.getApplication().equals(service.getApplicationName())).map(appPriv -> appPriv.getPrivileges()).flatMap(Arrays::stream).collect(Collectors.toUnmodifiableSet())));
        this.actionsResolver.getActions(service.getApplicationName(), (ActionListener<Set<String>>)groupedListener);
    }

    public static class UserPrivileges {
        public final String principal;
        public final boolean hasAccess;
        public final Set<String> roles;

        public UserPrivileges(String principal, boolean hasAccess, Set<String> roles) {
            this.principal = Objects.requireNonNull(principal, "principal may not be null");
            if (!hasAccess && !roles.isEmpty()) {
                throw new IllegalArgumentException("a user without access may not have roles ([" + roles + "])");
            }
            this.hasAccess = hasAccess;
            this.roles = Set.copyOf((Collection)Objects.requireNonNull(roles, "roles may not be null"));
        }

        public String toString() {
            StringBuilder str = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append(this.principal).append(", ").append(this.hasAccess);
            if (this.hasAccess) {
                str.append(", ").append(this.roles);
            }
            str.append("}");
            return str.toString();
        }

        public static UserPrivileges noAccess(String principal) {
            return new UserPrivileges(principal, false, Set.of());
        }
    }
}

