/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.idp.action.SamlMetadataRequest;
import org.elasticsearch.xpack.idp.action.SamlMetadataResponse;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.idp.SamlMetadataGenerator;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;

public class TransportSamlMetadataAction
extends HandledTransportAction<SamlMetadataRequest, SamlMetadataResponse> {
    private final SamlIdentityProvider identityProvider;
    private final SamlFactory samlFactory;

    @Inject
    public TransportSamlMetadataAction(TransportService transportService, ActionFilters actionFilters, SamlIdentityProvider idp, SamlFactory factory) {
        super("cluster:admin/idp/saml/metadata", transportService, actionFilters, SamlMetadataRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.identityProvider = idp;
        this.samlFactory = factory;
    }

    protected void doExecute(Task task, SamlMetadataRequest request, ActionListener<SamlMetadataResponse> listener) {
        SamlMetadataGenerator generator = new SamlMetadataGenerator(this.samlFactory, this.identityProvider);
        generator.generateMetadata(request.getSpEntityId(), request.getAssertionConsumerService(), listener);
    }
}

