/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.writeloadforecaster;

import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.BooleanSupplier;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataStats;
import org.elasticsearch.cluster.metadata.IndexWriteLoad;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.writeloadforecaster.WriteLoadForecasterPlugin;

class LicensedWriteLoadForecaster
implements WriteLoadForecaster {
    public static final Setting<TimeValue> MAX_INDEX_AGE_SETTING = Setting.timeSetting((String)"write_load_forecaster.max_index_age", (TimeValue)TimeValue.timeValueDays((long)7L), (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final BooleanSupplier hasValidLicense;
    private final ThreadPool threadPool;
    private volatile TimeValue maxIndexAge;

    LicensedWriteLoadForecaster(BooleanSupplier hasValidLicense, ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this(hasValidLicense, threadPool, (TimeValue)MAX_INDEX_AGE_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(MAX_INDEX_AGE_SETTING, this::setMaxIndexAgeSetting);
    }

    LicensedWriteLoadForecaster(BooleanSupplier hasValidLicense, ThreadPool threadPool, TimeValue maxIndexAge) {
        this.hasValidLicense = hasValidLicense;
        this.threadPool = threadPool;
        this.maxIndexAge = maxIndexAge;
    }

    private void setMaxIndexAgeSetting(TimeValue updatedMaxIndexAge) {
        this.maxIndexAge = updatedMaxIndexAge;
    }

    public Metadata.Builder withWriteLoadForecastForWriteIndex(String dataStreamName, Metadata.Builder metadata) {
        if (!this.hasValidLicense.getAsBoolean()) {
            return metadata;
        }
        DataStream dataStream = metadata.dataStream(dataStreamName);
        if (dataStream == null) {
            return metadata;
        }
        LicensedWriteLoadForecaster.clearPreviousForecast(dataStream, metadata);
        List<IndexWriteLoad> indicesWriteLoadWithinMaxAgeRange = DataStream.getIndicesWithinMaxAgeRange((DataStream)dataStream, arg_0 -> ((Metadata.Builder)metadata).getSafe(arg_0), (TimeValue)this.maxIndexAge, () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis()).stream().filter(index -> !index.equals((Object)dataStream.getWriteIndex())).map(arg_0 -> ((Metadata.Builder)metadata).getSafe(arg_0)).map(IndexMetadata::getStats).filter(Objects::nonNull).map(IndexMetadataStats::writeLoad).filter(Objects::nonNull).toList();
        OptionalDouble forecastIndexWriteLoad = LicensedWriteLoadForecaster.forecastIndexWriteLoad(indicesWriteLoadWithinMaxAgeRange);
        if (forecastIndexWriteLoad.isEmpty()) {
            return metadata;
        }
        IndexMetadata writeIndex = metadata.getSafe(dataStream.getWriteIndex());
        metadata.put(IndexMetadata.builder((IndexMetadata)writeIndex).indexWriteLoadForecast(Double.valueOf(forecastIndexWriteLoad.getAsDouble())).build(), false);
        return metadata;
    }

    private static void clearPreviousForecast(DataStream dataStream, Metadata.Builder metadata) {
        if (dataStream.getIndices().size() > 1) {
            Index previousWriteIndex = (Index)dataStream.getIndices().get(dataStream.getIndices().size() - 2);
            IndexMetadata previousWriteIndexMetadata = metadata.getSafe(previousWriteIndex);
            IndexMetadata.Builder previousWriteIndexMetadataBuilder = IndexMetadata.builder((IndexMetadata)previousWriteIndexMetadata).indexWriteLoadForecast(null);
            if (previousWriteIndexMetadata.getSettings().hasValue(WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.getKey())) {
                Settings.Builder previousWriteIndexSettings = Settings.builder().put(previousWriteIndexMetadata.getSettings());
                previousWriteIndexSettings.remove(WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.getKey());
                previousWriteIndexMetadataBuilder.settings(previousWriteIndexSettings);
                previousWriteIndexMetadataBuilder.settingsVersion(previousWriteIndexMetadata.getSettingsVersion() + 1L);
            }
            metadata.put(previousWriteIndexMetadataBuilder.build(), false);
        }
    }

    static OptionalDouble forecastIndexWriteLoad(List<IndexWriteLoad> indicesWriteLoadWithinMaxAgeRange) {
        double totalWeightedWriteLoad = 0.0;
        long totalShardUptime = 0L;
        for (IndexWriteLoad writeLoad : indicesWriteLoadWithinMaxAgeRange) {
            for (int shardId = 0; shardId < writeLoad.numberOfShards(); ++shardId) {
                OptionalDouble writeLoadForShard = writeLoad.getWriteLoadForShard(shardId);
                OptionalLong uptimeInMillisForShard = writeLoad.getUptimeInMillisForShard(shardId);
                if (!writeLoadForShard.isPresent()) continue;
                assert (uptimeInMillisForShard.isPresent());
                double shardWriteLoad = writeLoadForShard.getAsDouble();
                long shardUptimeInMillis = uptimeInMillisForShard.getAsLong();
                totalWeightedWriteLoad += shardWriteLoad * (double)shardUptimeInMillis;
                totalShardUptime += shardUptimeInMillis;
            }
        }
        return totalShardUptime == 0L ? OptionalDouble.empty() : OptionalDouble.of(totalWeightedWriteLoad / (double)totalShardUptime);
    }

    @SuppressForbidden(reason="This is the only place where IndexMetadata#getForecastedWriteLoad is allowed to be used")
    public OptionalDouble getForecastedWriteLoad(IndexMetadata indexMetadata) {
        if (!this.hasValidLicense.getAsBoolean()) {
            return OptionalDouble.empty();
        }
        if (WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.exists(indexMetadata.getSettings())) {
            Double overrideWriteLoadForecast = (Double)WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.get(indexMetadata.getSettings());
            return OptionalDouble.of(overrideWriteLoadForecast);
        }
        return indexMetadata.getForecastedWriteLoad();
    }
}

