/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class ClearCcrRestoreSessionAction
extends ActionType<ActionResponse.Empty> {
    public static final ClearCcrRestoreSessionAction INTERNAL_INSTANCE = new ClearCcrRestoreSessionAction();
    public static final String INTERNAL_NAME = "internal:admin/ccr/restore/session/clear";
    public static final String NAME = "indices:internal/admin/ccr/restore/session/clear";
    public static final ClearCcrRestoreSessionAction INSTANCE = new ClearCcrRestoreSessionAction("indices:internal/admin/ccr/restore/session/clear");
    public static final RemoteClusterActionType<ActionResponse.Empty> REMOTE_TYPE = RemoteClusterActionType.emptyResponse((String)"indices:internal/admin/ccr/restore/session/clear");
    public static final RemoteClusterActionType<ActionResponse.Empty> REMOTE_INTERNAL_TYPE = RemoteClusterActionType.emptyResponse((String)"internal:admin/ccr/restore/session/clear");

    private ClearCcrRestoreSessionAction() {
        this(INTERNAL_NAME);
    }

    private ClearCcrRestoreSessionAction(String name) {
        super(name);
    }

    public static class TransportAction
    extends TransportDeleteCcrRestoreSessionAction {
        @Inject
        public TransportAction(ActionFilters actionFilters, TransportService transportService, CcrRestoreSourceService ccrRestoreService) {
            super(ClearCcrRestoreSessionAction.NAME, actionFilters, transportService, ccrRestoreService);
        }

        @Override
        protected void validate(ClearCcrRestoreSessionRequest request) {
            ShardId shardId = request.getShardId();
            assert (shardId != null) : "shardId must be specified for the request";
            this.ccrRestoreService.ensureSessionShardIdConsistency(request.getSessionUUID(), shardId);
        }
    }

    public static class InternalTransportAction
    extends TransportDeleteCcrRestoreSessionAction {
        @Inject
        public InternalTransportAction(ActionFilters actionFilters, TransportService transportService, CcrRestoreSourceService ccrRestoreService) {
            super(ClearCcrRestoreSessionAction.INTERNAL_NAME, actionFilters, transportService, ccrRestoreService);
        }
    }

    static abstract class TransportDeleteCcrRestoreSessionAction
    extends HandledTransportAction<ClearCcrRestoreSessionRequest, ActionResponse.Empty> {
        protected final CcrRestoreSourceService ccrRestoreService;

        private TransportDeleteCcrRestoreSessionAction(String actionName, ActionFilters actionFilters, TransportService transportService, CcrRestoreSourceService ccrRestoreService) {
            super(actionName, transportService, actionFilters, ClearCcrRestoreSessionRequest::new, (Executor)transportService.getThreadPool().executor("generic"));
            TransportActionProxy.registerProxyAction((TransportService)transportService, (String)actionName, (boolean)false, in -> ActionResponse.Empty.INSTANCE);
            this.ccrRestoreService = ccrRestoreService;
        }

        protected void doExecute(Task task, ClearCcrRestoreSessionRequest request, ActionListener<ActionResponse.Empty> listener) {
            this.validate(request);
            this.ccrRestoreService.closeSession(request.getSessionUUID());
            listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
        }

        protected void validate(ClearCcrRestoreSessionRequest request) {
        }
    }
}

