/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFRankBuilder;
import org.elasticsearch.xpack.rank.rrf.RRFRankPlugin;

public final class RRFRetrieverBuilder
extends RetrieverBuilder {
    public static final NodeFeature RRF_RETRIEVER_SUPPORTED = new NodeFeature("rrf_retriever_supported");
    public static final ParseField RETRIEVERS_FIELD = new ParseField("retrievers", new String[0]);
    public static final ParseField WINDOW_SIZE_FIELD = new ParseField("window_size", new String[0]);
    public static final ParseField RANK_CONSTANT_FIELD = new ParseField("rank_constant", new String[0]);
    public static final ObjectParser<RRFRetrieverBuilder, RetrieverParserContext> PARSER = new ObjectParser("rrf", RRFRetrieverBuilder::new);
    List<RetrieverBuilder> retrieverBuilders = Collections.emptyList();
    int windowSize = 10;
    int rankConstant = 60;

    public static RRFRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(RRF_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [rrf]", new Object[0]);
        }
        if (!RRFRankPlugin.RANK_RRF_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"Reciprocal Rank Fusion (RRF)");
        }
        return (RRFRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        if (compoundUsed) {
            throw new IllegalArgumentException("[rank] cannot be used in children of compound retrievers");
        }
        for (RetrieverBuilder retrieverBuilder : this.retrieverBuilders) {
            if (!this.preFilterQueryBuilders.isEmpty()) {
                retrieverBuilder.getPreFilterQueryBuilders().addAll(this.preFilterQueryBuilders);
            }
            retrieverBuilder.extractToSearchSourceBuilder(searchSourceBuilder, true);
        }
        searchSourceBuilder.rankBuilder((RankBuilder)new RRFRankBuilder(this.windowSize, this.rankConstant));
    }

    public String getName() {
        return "rrf";
    }

    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.retrieverBuilders.isEmpty()) {
            builder.startArray(RETRIEVERS_FIELD.getPreferredName());
            for (RetrieverBuilder retrieverBuilder : this.retrieverBuilders) {
                builder.startObject();
                builder.field(retrieverBuilder.getName());
                retrieverBuilder.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.field(WINDOW_SIZE_FIELD.getPreferredName(), this.windowSize);
        builder.field(RANK_CONSTANT_FIELD.getPreferredName(), this.rankConstant);
    }

    public boolean doEquals(Object o) {
        RRFRetrieverBuilder that = (RRFRetrieverBuilder)((Object)o);
        return this.windowSize == that.windowSize && this.rankConstant == that.rankConstant && Objects.equals(this.retrieverBuilders, that.retrieverBuilders);
    }

    public int doHashCode() {
        return Objects.hash(this.retrieverBuilders, this.windowSize, this.rankConstant);
    }

    static {
        PARSER.declareObjectArray((r, v) -> {
            r.retrieverBuilders = v;
        }, (p, c) -> {
            p.nextToken();
            String name = p.currentName();
            RetrieverBuilder retrieverBuilder = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, name, c);
            p.nextToken();
            return retrieverBuilder;
        }, RETRIEVERS_FIELD);
        PARSER.declareInt((r, v) -> {
            r.windowSize = v;
        }, WINDOW_SIZE_FIELD);
        PARSER.declareInt((r, v) -> {
            r.rankConstant = v;
        }, RANK_CONSTANT_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)"rrf", PARSER);
    }
}

