/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.ArrayList;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;

public final class QueryBuilderHelper {
    private QueryBuilderHelper() {
    }

    public static Optional<QueryBuilder> buildTokenFilterQuery(String identityField, String[] tokens) {
        if (Strings.isAllOrWildcard((String[])tokens)) {
            return Optional.empty();
        }
        BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
        ArrayList<String> terms = new ArrayList<String>();
        for (String token : tokens) {
            if (Regex.isSimpleMatchPattern((String)token)) {
                shouldQueries.should((QueryBuilder)new WildcardQueryBuilder(identityField, token));
                continue;
            }
            terms.add(token);
        }
        if (!terms.isEmpty()) {
            shouldQueries.should((QueryBuilder)new TermsQueryBuilder(identityField, terms));
        }
        if (shouldQueries.should().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(shouldQueries);
    }
}

