/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.ml.job.process.AbstractInitializableRunnable;
import org.elasticsearch.xpack.ml.job.process.AbstractProcessWorkerExecutorService;

public class ProcessWorkerExecutorService
extends AbstractProcessWorkerExecutorService<Runnable> {
    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public ProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity) {
        super(contextHolder, processName, queueCapacity, LinkedBlockingQueue::new);
    }

    @Override
    public synchronized void execute(Runnable command) {
        if (command instanceof AbstractInitializableRunnable) {
            AbstractInitializableRunnable initializableRunnable = (AbstractInitializableRunnable)((Object)command);
            initializableRunnable.init();
        }
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(this.processName + " worker service has shutdown", true);
            if (command instanceof AbstractRunnable) {
                AbstractRunnable runnable = (AbstractRunnable)command;
                runnable.onRejection((Exception)((Object)rejected));
                return;
            }
            throw rejected;
        }
        boolean added = this.queue.offer(this.contextHolder.preserveContext(command));
        if (!added) {
            throw new EsRejectedExecutionException(this.processName + " queue is full. Unable to execute command", false);
        }
    }
}

