/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.action.CoordinatedInferenceAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.FillMaskConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NerConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PassThroughConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.QuestionAnsweringConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ZeroShotClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.loadingservice.LocalModel;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.utils.InferenceProcessorInfoExtractor;

public class InferenceProcessor
extends AbstractProcessor {
    public static final Setting<Integer> MAX_INFERENCE_PROCESSORS = Setting.intSetting((String)"xpack.ml.max_inference_processors", (int)50, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final String TYPE = "inference";
    public static final String MODEL_ID = "model_id";
    public static final String INFERENCE_CONFIG = "inference_config";
    public static final String IGNORE_MISSING = "ignore_missing";
    public static final String TARGET_FIELD = "target_field";
    public static final String FIELD_MAPPINGS = "field_mappings";
    public static final String FIELD_MAP = "field_map";
    private static final String DEFAULT_TARGET_FIELD = "ml.inference";
    public static final String INPUT_OUTPUT = "input_output";
    public static final String INPUT_FIELD = "input_field";
    public static final String OUTPUT_FIELD = "output_field";
    private final Client client;
    private final String modelId;
    private final String targetField;
    private final InferenceConfigUpdate inferenceConfig;
    private final Map<String, String> fieldMap;
    private final InferenceAuditor auditor;
    private volatile boolean previouslyLicensed;
    private final AtomicBoolean shouldAudit = new AtomicBoolean(true);
    private final List<Factory.InputConfig> inputs;
    private final boolean configuredWithInputsFields;
    private final boolean ignoreMissing;

    public static InferenceProcessor fromInputFieldConfiguration(Client client, InferenceAuditor auditor, String tag, String description, String modelId, InferenceConfigUpdate inferenceConfig, List<Factory.InputConfig> inputs, boolean ignoreMissing) {
        return new InferenceProcessor(client, auditor, tag, description, null, modelId, inferenceConfig, null, inputs, true, ignoreMissing);
    }

    public static InferenceProcessor fromTargetFieldConfiguration(Client client, InferenceAuditor auditor, String tag, String description, String targetField, String modelId, InferenceConfigUpdate inferenceConfig, Map<String, String> fieldMap) {
        return new InferenceProcessor(client, auditor, tag, description, targetField, modelId, inferenceConfig, fieldMap, null, false, false);
    }

    private InferenceProcessor(Client client, InferenceAuditor auditor, String tag, String description, String targetField, String modelId, InferenceConfigUpdate inferenceConfig, Map<String, String> fieldMap, List<Factory.InputConfig> inputs, boolean configuredWithInputsFields, boolean ignoreMissing) {
        super(tag, description);
        this.configuredWithInputsFields = configuredWithInputsFields;
        this.client = (Client)ExceptionsHelper.requireNonNull((Object)client, (String)"client");
        this.auditor = (InferenceAuditor)((Object)ExceptionsHelper.requireNonNull((Object)((Object)auditor), (String)"auditor"));
        this.modelId = (String)ExceptionsHelper.requireNonNull((Object)modelId, (String)MODEL_ID);
        this.inferenceConfig = inferenceConfig;
        this.ignoreMissing = ignoreMissing;
        if (configuredWithInputsFields) {
            this.inputs = (List)ExceptionsHelper.requireNonNull(inputs, (String)INPUT_OUTPUT);
            this.targetField = null;
            this.fieldMap = null;
        } else {
            this.inputs = null;
            this.targetField = (String)ExceptionsHelper.requireNonNull((Object)targetField, (String)TARGET_FIELD);
            this.fieldMap = (Map)ExceptionsHelper.requireNonNull(fieldMap, (String)FIELD_MAP);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        CoordinatedInferenceAction.Request request;
        try {
            request = this.buildRequest(ingestDocument);
        }
        catch (ElasticsearchStatusException e2) {
            handler.accept(ingestDocument, (Exception)((Object)e2));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)CoordinatedInferenceAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> this.handleResponse((InferModelAction.Response)r, ingestDocument, handler), e -> handler.accept(ingestDocument, (Exception)e)));
    }

    void handleResponse(InferModelAction.Response response, IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        if (!this.previouslyLicensed) {
            this.previouslyLicensed = true;
        }
        if (!response.isLicensed()) {
            this.auditWarningAboutLicenseIfNecessary();
        }
        try {
            this.mutateDocument(response, ingestDocument);
            handler.accept(ingestDocument, null);
        }
        catch (ElasticsearchException ex) {
            handler.accept(ingestDocument, (Exception)((Object)ex));
        }
    }

    CoordinatedInferenceAction.Request buildRequest(IngestDocument ingestDocument) {
        if (this.configuredWithInputsFields) {
            ArrayList<String> requestInputs = new ArrayList<String>();
            for (Factory.InputConfig inputFields : this.inputs) {
                try {
                    String inputText = (String)ingestDocument.getFieldValue(inputFields.inputField, String.class, this.ignoreMissing);
                    if (inputText == null) {
                        inputText = "";
                    }
                    requestInputs.add(inputText);
                }
                catch (IllegalArgumentException e) {
                    if (ingestDocument.hasField(inputFields.inputField())) {
                        throw new IllegalArgumentException("input field [" + inputFields.inputField + "] cannot be processed because it is not a text field");
                    }
                    throw e;
                }
            }
            CoordinatedInferenceAction.Request request = CoordinatedInferenceAction.Request.forTextInput((String)this.modelId, requestInputs, (InferenceConfigUpdate)this.inferenceConfig, (Boolean)this.previouslyLicensed, (TimeValue)InferModelAction.Request.DEFAULT_TIMEOUT_FOR_INGEST);
            request.setPrefixType(TrainedModelPrefixStrings.PrefixType.INGEST);
            return request;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>(ingestDocument.getSourceAndMetadata());
        if (!ingestDocument.getIngestMetadata().isEmpty()) {
            fields.put("_ingest", ingestDocument.getIngestMetadata());
        }
        LocalModel.mapFieldsIfNecessary(fields, this.fieldMap);
        CoordinatedInferenceAction.Request request = CoordinatedInferenceAction.Request.forMapInput((String)this.modelId, List.of(fields), (InferenceConfigUpdate)this.inferenceConfig, (Boolean)this.previouslyLicensed, (TimeValue)InferModelAction.Request.DEFAULT_TIMEOUT_FOR_INGEST, (CoordinatedInferenceAction.Request.RequestModelType)CoordinatedInferenceAction.Request.RequestModelType.UNKNOWN);
        request.setPrefixType(TrainedModelPrefixStrings.PrefixType.INGEST);
        return request;
    }

    void auditWarningAboutLicenseIfNecessary() {
        if (this.shouldAudit.compareAndSet(true, false)) {
            this.auditor.warning(this.modelId, "This cluster is no longer licensed to use this model in the inference ingest processor. Please update your license information.");
        }
    }

    void mutateDocument(InferModelAction.Response response, IngestDocument ingestDocument) {
        if (response.getInferenceResults().isEmpty()) {
            throw new ElasticsearchStatusException("Unexpected empty inference response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        if (this.configuredWithInputsFields) {
            if (response.getInferenceResults().size() != this.inputs.size()) {
                throw new ElasticsearchStatusException("number of results [{}] does not match the number of inputs [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{response.getInferenceResults().size(), this.inputs.size()});
            }
            for (int i = 0; i < this.inputs.size(); ++i) {
                InferenceResults.writeResultToField((InferenceResults)((InferenceResults)response.getInferenceResults().get(i)), (IngestDocument)ingestDocument, (String)this.inputs.get(i).outputBasePath(), (String)this.inputs.get((int)i).outputField, (String)(response.getId() != null ? response.getId() : this.modelId), (i == 0 ? 1 : 0) != 0);
            }
        } else {
            assert (response.getInferenceResults().size() == 1);
            InferenceResults.writeResult((InferenceResults)((InferenceResults)response.getInferenceResults().get(0)), (IngestDocument)ingestDocument, (String)this.targetField, (String)(response.getId() != null ? response.getId() : this.modelId));
        }
    }

    public boolean isAsync() {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    boolean isConfiguredWithInputsFields() {
        return this.configuredWithInputsFields;
    }

    public List<Factory.InputConfig> getInputs() {
        return this.inputs;
    }

    Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    String getTargetField() {
        return this.targetField;
    }

    InferenceConfigUpdate getInferenceConfig() {
        return this.inferenceConfig;
    }

    InferenceAuditor getAuditor() {
        return this.auditor;
    }

    public static final class Factory
    implements Processor.Factory,
    Consumer<ClusterState> {
        private static final Logger logger = LogManager.getLogger(Factory.class);
        private final Client client;
        private final InferenceAuditor auditor;
        private volatile ClusterState clusterState = ClusterState.EMPTY_STATE;
        private volatile int maxIngestProcessors;
        private volatile MlConfigVersion minNodeVersion = MlConfigVersion.CURRENT;

        public Factory(Client client, ClusterService clusterService, Settings settings, boolean includeNodeInfo) {
            this.client = client;
            this.maxIngestProcessors = (Integer)MAX_INFERENCE_PROCESSORS.get(settings);
            this.auditor = new InferenceAuditor(client, clusterService, includeNodeInfo);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_INFERENCE_PROCESSORS, this::setMaxIngestProcessors);
        }

        @Override
        public void accept(ClusterState state) {
            try {
                this.clusterState = state;
                this.minNodeVersion = MlConfigVersion.getMinMlConfigVersion((DiscoveryNodes)state.nodes());
            }
            catch (Exception ex) {
                logger.debug("failed gathering processors for pipelines", (Throwable)ex);
            }
        }

        public InferenceProcessor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) {
            List<Map<String, Object>> inputs;
            boolean configuredWithInputFields;
            int currentInferenceProcessors = InferenceProcessorInfoExtractor.countInferenceProcessors(this.clusterState);
            if (this.maxIngestProcessors <= currentInferenceProcessors) {
                throw new ElasticsearchStatusException("Max number of inference processors reached, total inference processors [{}]. Adjust the setting [{}]: [{}] if a greater number is desired.", RestStatus.CONFLICT, new Object[]{currentInferenceProcessors, MAX_INFERENCE_PROCESSORS.getKey(), this.maxIngestProcessors});
            }
            String modelId = ConfigurationUtils.readStringProperty((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.MODEL_ID);
            InferenceConfigUpdate inferenceConfigUpdate = null;
            Map inferenceConfigMap = ConfigurationUtils.readOptionalMap((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.INFERENCE_CONFIG);
            if (inferenceConfigMap != null) {
                inferenceConfigUpdate = this.inferenceConfigUpdateFromMap(inferenceConfigMap);
            }
            boolean bl = configuredWithInputFields = (inputs = this.readOptionalInputOutPutConfig(config, tag)) != null;
            if (configuredWithInputFields) {
                List<InputConfig> parsedInputs = this.parseInputFields(tag, inputs);
                boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.IGNORE_MISSING, (boolean)false);
                String targetField = ConfigurationUtils.readOptionalStringProperty((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.TARGET_FIELD);
                if (targetField != null) {
                    throw ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, (String)InferenceProcessor.TARGET_FIELD, (String)"option is incompatible with [input_output]. Use the [output_field] option to specify where to write the inference results to.");
                }
                if (inferenceConfigUpdate != null && inferenceConfigUpdate.getResultsField() != null) {
                    throw ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, null, (String)("The [inference_config." + InferenceConfig.RESULTS_FIELD.getPreferredName() + "] setting is incompatible with using [input_output]. Prefer to use the [input_output.output_field] option to specify where to write the inference results to."));
                }
                return InferenceProcessor.fromInputFieldConfiguration(this.client, this.auditor, tag, description, modelId, inferenceConfigUpdate, parsedInputs, ignoreMissing);
            }
            Object defaultTargetField = tag == null ? InferenceProcessor.DEFAULT_TARGET_FIELD : "ml.inference." + tag;
            String targetField = ConfigurationUtils.readStringProperty((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.TARGET_FIELD, (String)defaultTargetField);
            Map fieldMap = ConfigurationUtils.readOptionalMap((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.FIELD_MAP);
            if (fieldMap == null && (fieldMap = ConfigurationUtils.readOptionalMap((String)InferenceProcessor.TYPE, (String)tag, config, (String)InferenceProcessor.FIELD_MAPPINGS)) != null) {
                LoggingDeprecationHandler.INSTANCE.logRenamedField(null, () -> null, InferenceProcessor.FIELD_MAPPINGS, InferenceProcessor.FIELD_MAP);
            }
            if (fieldMap == null) {
                fieldMap = Collections.emptyMap();
            }
            return InferenceProcessor.fromTargetFieldConfiguration(this.client, this.auditor, tag, description, targetField, modelId, inferenceConfigUpdate, fieldMap);
        }

        void setMaxIngestProcessors(int maxIngestProcessors) {
            logger.trace("updating setting maxIngestProcessors from [{}] to [{}]", (Object)this.maxIngestProcessors, (Object)maxIngestProcessors);
            this.maxIngestProcessors = maxIngestProcessors;
        }

        InferenceConfigUpdate inferenceConfigUpdateFromMap(Map<String, Object> configMap) {
            ExceptionsHelper.requireNonNull(configMap, (String)InferenceProcessor.INFERENCE_CONFIG);
            if (configMap.size() != 1) {
                throw ExceptionsHelper.badRequestException((String)"{} must be an object with one inference type mapped to an object.", (Object[])new Object[]{InferenceProcessor.INFERENCE_CONFIG});
            }
            Object value = configMap.values().iterator().next();
            if (!(value instanceof Map)) {
                throw ExceptionsHelper.badRequestException((String)"{} must be an object with one inference type mapped to an object.", (Object[])new Object[]{InferenceProcessor.INFERENCE_CONFIG});
            }
            Map valueMap = (Map)value;
            if (configMap.containsKey(ClassificationConfig.NAME.getPreferredName())) {
                this.checkSupportedVersion((InferenceConfig)ClassificationConfig.EMPTY_PARAMS);
                return ClassificationConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("fill_mask")) {
                this.checkNlpSupported("fill_mask");
                return FillMaskConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("ner")) {
                this.checkNlpSupported("ner");
                return NerConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("pass_through")) {
                this.checkNlpSupported("pass_through");
                return PassThroughConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey(RegressionConfig.NAME.getPreferredName())) {
                this.checkSupportedVersion((InferenceConfig)RegressionConfig.EMPTY_PARAMS);
                return RegressionConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("text_classification")) {
                this.checkNlpSupported("text_classification");
                return TextClassificationConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("text_embedding")) {
                this.checkNlpSupported("text_embedding");
                return TextEmbeddingConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("text_expansion")) {
                this.checkNlpSupported("text_expansion");
                return TextExpansionConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("text_similarity")) {
                this.checkNlpSupported("text_similarity");
                return TextSimilarityConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("zero_shot_classification")) {
                this.checkNlpSupported("zero_shot_classification");
                return ZeroShotClassificationConfigUpdate.fromMap((Map)valueMap);
            }
            if (configMap.containsKey("question_answering")) {
                this.checkNlpSupported("question_answering");
                return QuestionAnsweringConfigUpdate.fromMap((Map)valueMap);
            }
            throw ExceptionsHelper.badRequestException((String)"unrecognized inference configuration type {}. Supported types {}", (Object[])new Object[]{configMap.keySet(), List.of(ClassificationConfig.NAME.getPreferredName(), RegressionConfig.NAME.getPreferredName(), "fill_mask", "ner", "pass_through", "question_answering", "text_classification", "text_embedding", "text_expansion", "text_similarity", "zero_shot_classification")});
        }

        void checkNlpSupported(String taskType) {
            if (NlpConfig.MINIMUM_NLP_SUPPORTED_VERSION.after((VersionId)this.minNodeVersion)) {
                throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Configuration [{0}] requires minimum node version [{1}] (current minimum node version [{2}]", (Object[])new Object[]{taskType, NlpConfig.MINIMUM_NLP_SUPPORTED_VERSION, this.minNodeVersion}), (Object[])new Object[0]);
            }
        }

        void checkSupportedVersion(InferenceConfig config) {
            if (config.getMinimalSupportedMlConfigVersion().after((VersionId)this.minNodeVersion)) {
                throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Configuration [{0}] requires minimum node version [{1}] (current minimum node version [{2}]", (Object[])new Object[]{config.getName(), config.getMinimalSupportedMlConfigVersion(), this.minNodeVersion}), (Object[])new Object[0]);
            }
        }

        List<InputConfig> parseInputFields(String tag, List<Map<String, Object>> inputs) {
            if (inputs.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, (String)InferenceProcessor.INPUT_OUTPUT, (String)"property cannot be empty at least one is required");
            }
            HashSet<String> inputNames = new HashSet<String>();
            HashSet<String> outputNames = new HashSet<String>();
            ArrayList<InputConfig> parsedInputs = new ArrayList<InputConfig>();
            for (Map<String, Object> input : inputs) {
                String inputField = ConfigurationUtils.readStringProperty((String)InferenceProcessor.TYPE, (String)tag, input, (String)InferenceProcessor.INPUT_FIELD);
                String outputField = ConfigurationUtils.readStringProperty((String)InferenceProcessor.TYPE, (String)tag, input, (String)InferenceProcessor.OUTPUT_FIELD);
                if (!inputNames.add(inputField)) {
                    throw this.duplicatedFieldNameError(InferenceProcessor.INPUT_FIELD, inputField, tag);
                }
                if (!outputNames.add(outputField)) {
                    throw this.duplicatedFieldNameError(InferenceProcessor.OUTPUT_FIELD, outputField, tag);
                }
                Tuple<String, String> outputPaths = Factory.extractBasePathAndFinalElement(outputField);
                if (input.isEmpty()) {
                    parsedInputs.add(new InputConfig(inputField, (String)outputPaths.v1(), (String)outputPaths.v2(), Map.of()));
                    continue;
                }
                parsedInputs.add(new InputConfig(inputField, (String)outputPaths.v1(), (String)outputPaths.v2(), new HashMap<String, Object>(input)));
            }
            return parsedInputs;
        }

        List<Map<String, Object>> readOptionalInputOutPutConfig(Map<String, Object> config, String tag) {
            Object inputOutputs = config.remove(InferenceProcessor.INPUT_OUTPUT);
            if (inputOutputs == null) {
                return null;
            }
            if (inputOutputs instanceof List) {
                List inputOutputList = (List)inputOutputs;
                if (!inputOutputList.isEmpty() && !(inputOutputList.get(0) instanceof Map)) {
                    throw ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, (String)InferenceProcessor.INPUT_OUTPUT, (String)"property isn't a list of maps");
                }
                return inputOutputList;
            }
            if (inputOutputs instanceof Map) {
                return List.of((Map)inputOutputs);
            }
            throw ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, (String)InferenceProcessor.INPUT_OUTPUT, (String)"property isn't a map or list of maps");
        }

        private ElasticsearchException duplicatedFieldNameError(String property, String fieldName, String tag) {
            return ConfigurationUtils.newConfigurationException((String)InferenceProcessor.TYPE, (String)tag, (String)property, (String)("names must be unique but [" + fieldName + "] is repeated"));
        }

        static Tuple<String, String> extractBasePathAndFinalElement(String outputField) {
            int lastIndex = outputField.lastIndexOf(46);
            if (lastIndex < 0) {
                return new Tuple(null, (Object)outputField);
            }
            return new Tuple((Object)outputField.substring(0, lastIndex), (Object)outputField.substring(lastIndex + 1));
        }

        public record InputConfig(String inputField, String outputBasePath, String outputField, Map<String, Object> extras) {
        }
    }
}

