/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public interface ChangeType
extends NamedWriteable,
NamedXContentObject {
    default public int changePoint() {
        return -1;
    }

    default public double pValue() {
        return 1.0;
    }

    public static class Dip
    extends AbstractChangePoint {
        public static final String NAME = "dip";

        public Dip(double pValue, int changePoint) {
            super(pValue, changePoint);
        }

        public Dip(StreamInput in) throws IOException {
            super(in);
        }

        public String getName() {
            return NAME;
        }
    }

    public static class Spike
    extends AbstractChangePoint {
        public static final String NAME = "spike";

        public Spike(double pValue, int changePoint) {
            super(pValue, changePoint);
        }

        public Spike(StreamInput in) throws IOException {
            super(in);
        }

        public String getName() {
            return NAME;
        }
    }

    public static class TrendChange
    implements ChangeType {
        public static final String NAME = "trend_change";
        private final double pValue;
        private final double rValue;
        private final int changePoint;

        public TrendChange(double pValue, double rValue, int changePoint) {
            this.pValue = pValue;
            this.rValue = rValue;
            this.changePoint = changePoint;
        }

        public TrendChange(StreamInput in) throws IOException {
            this.pValue = in.readDouble();
            this.rValue = in.readDouble();
            this.changePoint = in.readVInt();
        }

        @Override
        public double pValue() {
            return this.pValue;
        }

        @Override
        public int changePoint() {
            return this.changePoint;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("p_value", this.pValue).field("r_value", this.pValue).field("change_point", this.changePoint).endObject();
        }

        public String getWriteableName() {
            return this.getName();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.pValue);
            out.writeDouble(this.rValue);
            out.writeVInt(this.changePoint);
        }

        public String getName() {
            return NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrendChange that = (TrendChange)o;
            return Double.compare(that.pValue, this.pValue) == 0 && Double.compare(that.rValue, this.rValue) == 0 && this.changePoint == that.changePoint;
        }

        public int hashCode() {
            return Objects.hash(this.pValue, this.rValue, this.changePoint);
        }
    }

    public static class NonStationary
    implements ChangeType {
        public static final String NAME = "non_stationary";
        private final double pValue;
        private final double rValue;
        private final String trend;

        public NonStationary(double pValue, double rValue, String trend) {
            this.pValue = pValue;
            this.rValue = rValue;
            this.trend = trend;
        }

        public NonStationary(StreamInput in) throws IOException {
            this.pValue = in.readDouble();
            this.rValue = in.readDouble();
            this.trend = in.readString();
        }

        public String getTrend() {
            return this.trend;
        }

        @Override
        public double pValue() {
            return this.pValue;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("p_value", this.pValue).field("r_value", this.rValue).field("trend", this.trend).endObject();
        }

        public String getWriteableName() {
            return this.getName();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.pValue);
            out.writeDouble(this.rValue);
            out.writeString(this.trend);
        }

        public String getName() {
            return NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonStationary that = (NonStationary)o;
            return Double.compare(that.pValue, this.pValue) == 0 && Double.compare(that.rValue, this.rValue) == 0 && Objects.equals(this.trend, that.trend);
        }

        public int hashCode() {
            return Objects.hash(this.pValue, this.rValue, this.trend);
        }
    }

    public static class DistributionChange
    extends AbstractChangePoint {
        public static final String NAME = "distribution_change";

        public DistributionChange(double pValue, int changePoint) {
            super(pValue, changePoint);
        }

        public DistributionChange(StreamInput in) throws IOException {
            super(in);
        }

        public String getName() {
            return NAME;
        }
    }

    public static class StepChange
    extends AbstractChangePoint {
        public static final String NAME = "step_change";

        public StepChange(double pValue, int changePoint) {
            super(pValue, changePoint);
        }

        public StepChange(StreamInput in) throws IOException {
            super(in);
        }

        public String getName() {
            return NAME;
        }
    }

    public static class Stationary
    implements ChangeType {
        public static final String NAME = "stationary";

        public Stationary() {
        }

        public Stationary(StreamInput input) {
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().endObject();
        }

        public String getWriteableName() {
            return this.getName();
        }

        public void writeTo(StreamOutput out) throws IOException {
        }

        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && obj.getClass() == this.getClass();
        }
    }

    public static class Indeterminable
    implements ChangeType {
        public static final String NAME = "indeterminable";
        private final String reason;

        public Indeterminable(String reason) {
            this.reason = reason;
        }

        public Indeterminable(StreamInput input) throws IOException {
            this.reason = input.readString();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("reason", this.reason).endObject();
        }

        public String getWriteableName() {
            return this.getName();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
        }

        public String getName() {
            return NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Indeterminable that = (Indeterminable)o;
            return Objects.equals(this.reason, that.reason);
        }

        public int hashCode() {
            return Objects.hash(this.reason);
        }
    }

    public static abstract class AbstractChangePoint
    implements ChangeType {
        private final double pValue;
        private final int changePoint;

        protected AbstractChangePoint(double pValue, int changePoint) {
            this.pValue = pValue;
            this.changePoint = changePoint;
        }

        @Override
        public double pValue() {
            return this.pValue;
        }

        @Override
        public int changePoint() {
            return this.changePoint;
        }

        public AbstractChangePoint(StreamInput in) throws IOException {
            this.pValue = in.readDouble();
            this.changePoint = in.readVInt();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("p_value", this.pValue).field("change_point", this.changePoint).endObject();
        }

        public String getWriteableName() {
            return this.getName();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.pValue);
            out.writeVInt(this.changePoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractChangePoint that = (AbstractChangePoint)o;
            return Double.compare(that.pValue, this.pValue) == 0 && this.changePoint == that.changePoint;
        }

        public int hashCode() {
            return Objects.hash(this.pValue, this.changePoint);
        }
    }
}

