/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAssignmentAction;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;

public class TransportDeleteTrainedModelAssignmentAction
extends AcknowledgedTransportMasterNodeAction<DeleteTrainedModelAssignmentAction.Request> {
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;

    @Inject
    public TransportDeleteTrainedModelAssignmentAction(TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:internal/xpack/ml/model_allocation/delete", false, transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAssignmentAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.trainedModelAssignmentClusterService = trainedModelAssignmentClusterService;
    }

    protected void masterOperation(Task task, DeleteTrainedModelAssignmentAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.trainedModelAssignmentClusterService.removeModelAssignment(request.getModelId(), listener);
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAssignmentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

