/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.TransportIndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;

public final class MlInitializationService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlInitializationService.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);
    private final AtomicBoolean mlInternalIndicesHidden = new AtomicBoolean(false);
    private volatile String previousException;
    private final MlDailyMaintenanceService mlDailyMaintenanceService;
    private boolean isMaster = false;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client, MlAssignmentNotifier mlAssignmentNotifier, boolean isAnomalyDetectionEnabled, boolean isDataFrameAnalyticsEnabled, boolean isNlpEnabled) {
        this(client, threadPool, new MlDailyMaintenanceService(settings, Objects.requireNonNull(clusterService).getClusterName(), threadPool, client, clusterService, mlAssignmentNotifier, isAnomalyDetectionEnabled, isDataFrameAnalyticsEnabled, isNlpEnabled), clusterService);
    }

    public MlInitializationService(Client client, ThreadPool threadPool, MlDailyMaintenanceService dailyMaintenanceService, final ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.threadPool = threadPool;
        this.mlDailyMaintenanceService = dailyMaintenanceService;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND, MlInitializationService.this.mlDailyMaintenanceService::setDeleteExpiredDataRequestsPerSecond);
            }

            public void beforeStop() {
                MlInitializationService.this.offMaster();
            }
        });
    }

    public void onMaster() {
        this.mlDailyMaintenanceService.start();
        this.threadPool.executor("ml_utility").execute(this::makeMlInternalIndicesHidden);
    }

    public void offMaster() {
        this.mlDailyMaintenanceService.stop();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        if (this.isMaster && this.isIndexCreationInProgress.compareAndSet(false, true)) {
            AnnotationIndex.createAnnotationsIndexIfNecessary((Client)this.client, (ClusterState)event.state(), (TimeValue)MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT, (ActionListener)ActionListener.wrap(r -> this.isIndexCreationInProgress.set(false), e -> {
                if (e.getMessage().equals(this.previousException)) {
                    logger.debug("Error creating ML annotations index or aliases", (Throwable)e);
                } else {
                    this.previousException = e.getMessage();
                    logger.error("Error creating ML annotations index or aliases", (Throwable)e);
                }
                this.isIndexCreationInProgress.set(false);
            }));
        }
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }

    public boolean areMlInternalIndicesHidden() {
        return this.mlInternalIndicesHidden.get();
    }

    private void makeMlInternalIndicesHidden() {
        String[] mlHiddenIndexPatterns = MachineLearning.getMlHiddenIndexPatterns();
        ActionListener finalListener = ActionListener.wrap(updateAliasesResponse -> {
            if (!updateAliasesResponse.isAcknowledged()) {
                logger.warn("One or more of the ML internal aliases could not be made hidden.");
                return;
            }
            this.mlInternalIndicesHidden.set(true);
        }, e -> logger.warn("An error occurred while making ML internal indices and aliases hidden", (Throwable)e));
        ActionListener getAliasesResponseListener = ActionListener.wrap(getAliasesResponse -> {
            IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
            for (Map.Entry entry : getAliasesResponse.getAliases().entrySet()) {
                for (AliasMetadata existingAliasMetadata : (List)entry.getValue()) {
                    if (existingAliasMetadata.isHidden() != null && existingAliasMetadata.isHidden().booleanValue()) continue;
                    indicesAliasesRequest.addAliasAction(MlInitializationService.aliasReplacementAction((String)entry.getKey(), existingAliasMetadata));
                }
            }
            if (indicesAliasesRequest.getAliasActions().isEmpty()) {
                logger.debug("There are no ML internal aliases that need to be made hidden, [{}]", (Object)getAliasesResponse.getAliases());
                finalListener.onResponse((Object)IndicesAliasesResponse.ACKNOWLEDGED_NO_ERRORS);
                return;
            }
            String indicesWithNonHiddenAliasesString = indicesAliasesRequest.getAliasActions().stream().map(aliasAction -> aliasAction.indices()[0] + ": " + String.join((CharSequence)",", aliasAction.aliases())).collect(Collectors.joining("; "));
            logger.debug("The following ML internal aliases will now be made hidden: [{}]", (Object)indicesWithNonHiddenAliasesString);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportIndicesAliasesAction.TYPE, (ActionRequest)indicesAliasesRequest, (ActionListener)finalListener);
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        ActionListener updateSettingsListener = ActionListener.wrap(updateSettingsResponse -> {
            if (!updateSettingsResponse.isAcknowledged()) {
                logger.warn("One or more of the ML internal indices could not be made hidden.");
                return;
            }
            GetAliasesRequest getAliasesRequest = new GetAliasesRequest().indices(mlHiddenIndexPatterns).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAliasesAction.INSTANCE, (ActionRequest)getAliasesRequest, (ActionListener)getAliasesResponseListener);
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        ActionListener getSettingsListener = ActionListener.wrap(getSettingsResponse -> {
            CharSequence[] nonHiddenIndices = (String[])getSettingsResponse.getIndexToSettings().entrySet().stream().filter(e -> ((Settings)e.getValue()).getAsBoolean("index.hidden", Boolean.valueOf(false)) == false).map(Map.Entry::getKey).toArray(String[]::new);
            if (nonHiddenIndices.length == 0) {
                logger.debug("There are no ML internal indices that need to be made hidden, [{}]", getSettingsResponse);
                updateSettingsListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            String nonHiddenIndicesString = String.join((CharSequence)", ", nonHiddenIndices);
            logger.debug("The following ML internal indices will now be made hidden: [{}]", (Object)nonHiddenIndicesString);
            UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest().indices((String[])nonHiddenIndices).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN).settings(Collections.singletonMap("index.hidden", true));
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportUpdateSettingsAction.TYPE, (ActionRequest)updateSettingsRequest, (ActionListener)updateSettingsListener);
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(mlHiddenIndexPatterns).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN);
        this.client.admin().indices().getSettings(getSettingsRequest, getSettingsListener);
    }

    private static IndicesAliasesRequest.AliasActions aliasReplacementAction(String index, AliasMetadata existingAliasMetadata) {
        IndicesAliasesRequest.AliasActions addReplacementAliasAction = IndicesAliasesRequest.AliasActions.add().index(index).aliases(new String[]{existingAliasMetadata.getAlias()}).isHidden(Boolean.valueOf(true));
        if (existingAliasMetadata.writeIndex() != null) {
            addReplacementAliasAction.writeIndex(existingAliasMetadata.writeIndex());
        }
        if (existingAliasMetadata.filteringRequired()) {
            addReplacementAliasAction.filter(existingAliasMetadata.filter().string());
        }
        if (existingAliasMetadata.indexRouting() != null) {
            addReplacementAliasAction.indexRouting(existingAliasMetadata.indexRouting());
        }
        if (existingAliasMetadata.searchRouting() != null) {
            addReplacementAliasAction.searchRouting(existingAliasMetadata.searchRouting());
        }
        return addReplacementAliasAction;
    }
}

