/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.stats;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.geoip.DatabaseNodeService;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpDownloaderTaskExecutor;
import org.elasticsearch.ingest.geoip.stats.CacheStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpStatsAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GeoIpStatsTransportAction
extends TransportNodesAction<GeoIpStatsAction.Request, GeoIpStatsAction.Response, GeoIpStatsAction.NodeRequest, GeoIpStatsAction.NodeResponse> {
    private final TransportService transportService;
    private final DatabaseNodeService registry;
    private final GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor;

    @Inject
    public GeoIpStatsTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatabaseNodeService registry, GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor) {
        super(GeoIpStatsAction.INSTANCE.name(), clusterService, transportService, actionFilters, GeoIpStatsAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.transportService = transportService;
        this.registry = registry;
        this.geoIpDownloaderTaskExecutor = geoIpDownloaderTaskExecutor;
    }

    protected GeoIpStatsAction.Response newResponse(GeoIpStatsAction.Request request, List<GeoIpStatsAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new GeoIpStatsAction.Response(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected GeoIpStatsAction.NodeRequest newNodeRequest(GeoIpStatsAction.Request request) {
        return new GeoIpStatsAction.NodeRequest();
    }

    protected GeoIpStatsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GeoIpStatsAction.NodeResponse(in);
    }

    protected GeoIpStatsAction.NodeResponse nodeOperation(GeoIpStatsAction.NodeRequest request, Task task) {
        GeoIpDownloader geoIpTask = this.geoIpDownloaderTaskExecutor.getCurrentTask();
        GeoIpDownloaderStats downloaderStats = geoIpTask == null || geoIpTask.getStatus() == null ? null : geoIpTask.getStatus();
        CacheStats cacheStats = this.registry.getCacheStats();
        return new GeoIpStatsAction.NodeResponse(this.transportService.getLocalNode(), downloaderStats, cacheStats, this.registry.getAvailableDatabases(), this.registry.getFilesInTemp(), this.registry.getConfigDatabases());
    }
}

