/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.geoip2.model.AbstractResponse;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.stats.CacheStats;

final class GeoIpCache {
    static final AbstractResponse NO_RESULT = new AbstractResponse(){

        public String toString() {
            return "AbstractResponse[NO_RESULT]";
        }
    };
    private final LongSupplier relativeNanoTimeProvider;
    private final Cache<CacheKey, AbstractResponse> cache;
    private final AtomicLong hitsTimeInNanos = new AtomicLong(0L);
    private final AtomicLong missesTimeInNanos = new AtomicLong(0L);

    GeoIpCache(long maxSize, LongSupplier relativeNanoTimeProvider) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
        }
        this.relativeNanoTimeProvider = relativeNanoTimeProvider;
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    GeoIpCache(long maxSize) {
        this(maxSize, System::nanoTime);
    }

    <T extends AbstractResponse> T putIfAbsent(InetAddress ip, String databasePath, Function<InetAddress, AbstractResponse> retrieveFunction) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        long cacheStart = this.relativeNanoTimeProvider.getAsLong();
        AbstractResponse response = (AbstractResponse)this.cache.get((Object)cacheKey);
        long cacheRequestTime = this.relativeNanoTimeProvider.getAsLong() - cacheStart;
        if (response == null) {
            long retrieveStart = this.relativeNanoTimeProvider.getAsLong();
            response = retrieveFunction.apply(ip);
            if (response == null) {
                response = NO_RESULT;
            }
            this.cache.put((Object)cacheKey, (Object)response);
            long databaseRequestAndCachePutTime = this.relativeNanoTimeProvider.getAsLong() - retrieveStart;
            this.missesTimeInNanos.addAndGet(cacheRequestTime + databaseRequestAndCachePutTime);
        } else {
            this.hitsTimeInNanos.addAndGet(cacheRequestTime);
        }
        if (response == NO_RESULT) {
            return null;
        }
        return (T)response;
    }

    AbstractResponse get(InetAddress ip, String databasePath) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        return (AbstractResponse)this.cache.get((Object)cacheKey);
    }

    public int purgeCacheEntriesForDatabase(Path databaseFile) {
        String databasePath = databaseFile.toString();
        int counter = 0;
        for (CacheKey key : this.cache.keys()) {
            if (!key.databasePath.equals(databasePath)) continue;
            this.cache.invalidate((Object)key);
            ++counter;
        }
        return counter;
    }

    public int count() {
        return this.cache.count();
    }

    public CacheStats getCacheStats() {
        Cache.CacheStats stats = this.cache.stats();
        return new CacheStats(this.cache.count(), stats.getHits(), stats.getMisses(), stats.getEvictions(), TimeValue.nsecToMSec((long)this.hitsTimeInNanos.get()), TimeValue.nsecToMSec((long)this.missesTimeInNanos.get()));
    }

    private record CacheKey(InetAddress ip, String databasePath) {
    }
}

